/*
 * Decompiled with CFR 0.152.
 */
package junitx.extensions;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.Assert;
import junitx.framework.ComparableAssert;

public abstract class ComparabilityTestCase
extends TestCase {
    private Comparable less;
    private Comparable equal1;
    private Comparable equal2;
    private Comparable greater;

    public ComparabilityTestCase(String name) {
        super(name);
    }

    protected abstract Comparable createLessInstance() throws Exception;

    protected abstract Comparable createEqualInstance() throws Exception;

    protected abstract Comparable createGreaterInstance() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.less = this.createLessInstance();
        this.equal1 = this.createEqualInstance();
        this.equal2 = this.createEqualInstance();
        this.greater = this.createGreaterInstance();
        try {
            junit.framework.Assert.assertNotNull((String)"createLessInstance() returned null", (Object)this.less);
            junit.framework.Assert.assertNotNull((String)"createEqualInstance() returned null", (Object)this.equal1);
            junit.framework.Assert.assertNotNull((String)"2nd createEqualInstance() returned null", (Object)this.equal2);
            junit.framework.Assert.assertNotNull((String)"createGreaterInstance() returned null", (Object)this.greater);
            junit.framework.Assert.assertEquals((String)"less and equal1 of different classes", this.less.getClass(), this.equal1.getClass());
            junit.framework.Assert.assertEquals((String)"less and equal2 of different classes", this.less.getClass(), this.equal2.getClass());
            junit.framework.Assert.assertEquals((String)"less and greater of different classes", this.less.getClass(), this.greater.getClass());
            this.checkForEquality(this.equal1, this.equal2);
        }
        catch (AssertionFailedError ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    protected void checkForEquality(Comparable c1, Comparable c2) {
        Assert.assertNotSame("1st equal instance same as 2nd", this.equal1, this.equal2);
        junit.framework.Assert.assertEquals((String)"1st equal not equal to 2nd", (Object)this.equal1, (Object)this.equal2);
    }

    public final void testForReverseSigns() {
        junit.framework.Assert.assertEquals((String)"less vs. equal1", (int)this.sgn(this.less.compareTo(this.equal1)), (int)(-this.sgn(this.equal1.compareTo(this.less))));
        junit.framework.Assert.assertEquals((String)"less vs. equal2", (int)this.sgn(this.less.compareTo(this.equal2)), (int)(-this.sgn(this.equal2.compareTo(this.less))));
        junit.framework.Assert.assertEquals((String)"less vs. greater", (int)this.sgn(this.less.compareTo(this.greater)), (int)(-this.sgn(this.greater.compareTo(this.less))));
        junit.framework.Assert.assertEquals((String)"equal1 vs. equal2", (int)this.sgn(this.equal1.compareTo(this.equal2)), (int)(-this.sgn(this.equal2.compareTo(this.equal1))));
        junit.framework.Assert.assertEquals((String)"equal1 vs. greater", (int)this.sgn(this.equal1.compareTo(this.greater)), (int)(-this.sgn(this.greater.compareTo(this.equal1))));
        junit.framework.Assert.assertEquals((String)"equal2 vs. greater", (int)this.sgn(this.equal2.compareTo(this.greater)), (int)(-this.sgn(this.greater.compareTo(this.equal2))));
    }

    public final void testForSameSigns() {
        junit.framework.Assert.assertEquals((String)"equal vs. less", (int)this.sgn(this.equal1.compareTo(this.less)), (int)this.sgn(this.equal2.compareTo(this.less)));
        junit.framework.Assert.assertEquals((String)"equal vs. greater", (int)this.sgn(this.equal1.compareTo(this.greater)), (int)this.sgn(this.equal2.compareTo(this.greater)));
    }

    public final void testReturnValues() {
        ComparableAssert.assertLesser(this.equal1, this.less);
        ComparableAssert.assertLesser(this.equal2, this.less);
        ComparableAssert.assertGreater(this.less, this.greater);
        ComparableAssert.assertEquals(this.equal1, this.equal2);
        ComparableAssert.assertGreater(this.equal1, this.greater);
        ComparableAssert.assertGreater(this.equal2, this.greater);
    }

    public final void testForClassCastException() throws Exception {
        try {
            this.less.compareTo(new Object());
        }
        catch (ClassCastException success) {
            return;
        }
        junit.framework.Assert.fail((String)"should have thrown ClassCastException");
    }

    private int sgn(int x) {
        return x == 0 ? 0 : x / Math.abs(x);
    }
}

