package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the replay for file equals assertions.
 * </p>
 * 
 * @author Jeffrey Hall, Steffen Herbold
 * @version 2.0
 */
public class FileEqualsReplay implements IReplayable {

	/**
	 * <p>
	 * The file that should be equal to expectedFile.
	 * </p>
	 */
	String actualFile = null;

	/**
	 * <p>
	 * The file that is used as the reference.
	 * </p>
	 */
	String expectedFile = null;

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * Constructor. Creates a new FileEqualsReplay.
	 * </p>
	 * 
	 * @param expectedFile
	 *            name and path of the expected file
	 * @param actualFile
	 *            name and path of the actual file
	 */
	public FileEqualsReplay(String expectedFile, String actualFile) {
		this.expectedFile = expectedFile;
		this.actualFile = actualFile;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getReplay()
	 */
	public String getReplay() {

		actualFile = StringTools.xmlEntityReplacement(actualFile);
		expectedFile = StringTools.xmlEntityReplacement(expectedFile);

		StringBuilder currentMsgStr = new StringBuilder(800);
		currentMsgStr.append("  <fileEquals ");
		currentMsgStr.append("actualFile=\"" + actualFile + "\" ");
		currentMsgStr.append("expectedFile=\"" + expectedFile + "\"/>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getTarget()
	 */
	@Override
	public String getTarget() {
		return "targetNotUsed";
	}

}
