/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class ConfusionBetweenInheritedAndOuterMethod
extends BytecodeScanningDetector {
    BugAccumulator bugAccumulator;
    boolean hasThisDollarZero;

    public ConfusionBetweenInheritedAndOuterMethod(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visitJavaClass(JavaClass obj) {
        this.hasThisDollarZero = false;
        if (obj.getClassName().indexOf(36) >= 0) {
            super.visitJavaClass(obj);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    public void visit(Field f) {
        if (f.getName().equals("this$0")) {
            this.hasThisDollarZero = true;
        }
    }

    public void visit(Code obj) {
        if (this.hasThisDollarZero) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        int i;
        if (seen != 182) {
            return;
        }
        if (!this.getClassName().equals(this.getClassConstantOperand())) {
            return;
        }
        XMethod invokedMethod = XFactory.createXMethod(this.getDottedClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand(), false);
        if (invokedMethod.isResolved() && invokedMethod.getClassName().equals(this.getDottedClassConstantOperand())) {
            return;
        }
        String possibleTargetClass = this.getDottedClassName();
        String superClassName = this.getDottedSuperclassName();
        while ((i = possibleTargetClass.lastIndexOf(36)) > 0 && !(possibleTargetClass = possibleTargetClass.substring(0, i)).equals(superClassName)) {
            XMethod alternativeMethod = XFactory.createXMethod(possibleTargetClass, this.getNameConstantOperand(), this.getSigConstantOperand(), false);
            if (!alternativeMethod.isResolved() || !alternativeMethod.getClassName().equals(possibleTargetClass)) continue;
            String targetPackage = invokedMethod.getPackageName();
            String alternativePackage = alternativeMethod.getPackageName();
            int priority = 1;
            if (targetPackage.equals(alternativePackage)) {
                ++priority;
            }
            if (targetPackage.startsWith("javax.swing") || targetPackage.startsWith("java.awt")) {
                priority += 2;
            }
            if (invokedMethod.getName().equals(this.getMethodName())) {
                ++priority;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD", priority).addClassAndMethod(this).addMethod(invokedMethod).describe("METHOD_INHERITED").addMethod(alternativeMethod).describe("METHOD_ALTERNATIVE_TARGET"), this);
            break;
        }
    }
}

