package de.ugoe.cs.eventbench.models;

import java.util.Random;
import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>FirstOrderMarkovModelTest</code> contains tests for the class
 * <code>{@link FirstOrderMarkovModel}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FirstOrderMarkovModelTest {

	@Test
	public void testFirstOrderMarkovModel_1() throws Exception {
		Random r = new Random();

		FirstOrderMarkovModel result = new FirstOrderMarkovModel(r);

		assertNotNull(result);
		assertEquals(r, result.r);
		assertEquals(2, result.trieOrder);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testFirstOrderMarkovModel_2() throws Exception {
		new FirstOrderMarkovModel(null);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FirstOrderMarkovModelTest.class);
	}
}