package de.ugoe.cs.eventbench.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.*;

import de.ugoe.cs.eventbench.data.Event;
import static org.junit.Assert.*;

/**
 * The class <code>FirstOrderMarkovModelTest</code> contains tests for the class
 * <code>{@link FirstOrderMarkovModel}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FirstOrderMarkovModelTest {

	Collection<List<? extends Event<?>>> sequences;
	
	@Test
	public void testFirstOrderMarkovModel_1() throws Exception {
		Random r = new Random();

		FirstOrderMarkovModel result = new FirstOrderMarkovModel(r);

		assertNotNull(result);
		assertEquals(r, result.r);
		assertEquals(2, result.trieOrder);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testFirstOrderMarkovModel_2() throws Exception {
		new FirstOrderMarkovModel(null);
	}
	
	@Test
	public void testCalcEntropy() throws Exception {
		Random r = new Random();
		FirstOrderMarkovModel fixture = new FirstOrderMarkovModel(r);
		fixture.train(sequences);
		
		double result = fixture.calcEntropy();
		
		assertEquals(0.7392d, result, 0.0001);
	}
	
	@Before
	public void setUp() throws Exception {
		List<Event<?>> sequence = new ArrayList<Event<?>>();
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("b"));
		sequence.add(new Event<String>("r"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("c"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("d"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("b"));
		sequence.add(new Event<String>("r"));
		sequence.add(new Event<String>("a"));

		sequences = new ArrayList<List<? extends Event<?>>>();
		sequences.add(sequence);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FirstOrderMarkovModelTest.class);
	}
}