/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.jsr305.JSR305NullnessAnnotations;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierDefault;
import javax.annotation.meta.TypeQualifierNickname;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierResolver {
    static ClassDescriptor typeQualifier = DescriptorFactory.createClassDescriptor(TypeQualifier.class);
    static ClassDescriptor typeQualifierNickname = DescriptorFactory.createClassDescriptor(TypeQualifierNickname.class);
    static ClassDescriptor typeQualifierDefault = DescriptorFactory.createClassDescriptor(TypeQualifierDefault.class);
    static ClassDescriptor elementTypeDescriptor = DescriptorFactory.createClassDescriptor(ElementType.class);
    static ClassDescriptor googleNullable = DescriptorFactory.createClassDescriptor("com/google/common/base/Nullable");
    static ClassDescriptor intellijNullable = DescriptorFactory.createClassDescriptor("org/jetbrains/annotations/Nullable");

    public static Collection<AnnotationValue> resolveTypeQualifiers(AnnotationValue value) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, new LinkedList<ClassDescriptor>());
        return result;
    }

    public static Collection<AnnotationValue> resolveTypeQualifierDefaults(Collection<AnnotationValue> values, ElementType elementType) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierDefaults(value, elementType, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveTypeQualifierNicknames(AnnotationValue value, LinkedList<AnnotationValue> result, LinkedList<ClassDescriptor> onStack) {
        ClassDescriptor annotationClass = value.getAnnotationClass();
        if (onStack.contains(annotationClass)) {
            AnalysisContext.logError("Cycle found in type nicknames: " + onStack);
            return;
        }
        try {
            block14: {
                onStack.add(annotationClass);
                if (!annotationClass.equals(googleNullable) && !annotationClass.equals(intellijNullable)) break block14;
                TypeQualifierResolver.resolveTypeQualifierNicknames(new AnnotationValue(JSR305NullnessAnnotations.CHECK_FOR_NULL), result, onStack);
                return;
            }
            try {
                XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, annotationClass);
                if (c.getAnnotationDescriptors().contains(typeQualifierNickname)) {
                    for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                        if (c.equals(typeQualifierNickname)) continue;
                        TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, onStack);
                    }
                } else if (c.getAnnotationDescriptors().contains(typeQualifier)) {
                    result.add(value);
                }
            }
            catch (MissingClassException e) {
                TypeQualifierResolver.logMissingAnnotationClass(e);
                onStack.removeLast();
                return;
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error resolving " + annotationClass, e);
                onStack.removeLast();
                return;
            }
        }
        finally {
            onStack.removeLast();
        }
    }

    public static void logMissingAnnotationClass(MissingClassException e) {
        ClassDescriptor c = e.getClassDescriptor();
        if (c.getClassName().startsWith("javax.annotation")) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(c);
        }
    }

    public static Collection<AnnotationValue> resolveTypeQualifiers(Collection<AnnotationValue> values) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        LinkedList<ClassDescriptor> onStack = new LinkedList<ClassDescriptor>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, onStack);
        }
        return result;
    }

    private static void resolveTypeQualifierDefaults(AnnotationValue value, ElementType defaultFor, LinkedList<AnnotationValue> result) {
        try {
            XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, value.getAnnotationClass());
            AnnotationValue defaultAnnotation = c.getAnnotation(typeQualifierDefault);
            if (defaultAnnotation == null) {
                return;
            }
            for (Object o : (Object[])defaultAnnotation.getValue("value")) {
                if (!(o instanceof EnumValue)) continue;
                EnumValue e = (EnumValue)o;
                if (!e.desc.equals(elementTypeDescriptor) || !e.value.equals(defaultFor.name())) continue;
                for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                    if (d.equals(typeQualifierDefault)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, new LinkedList<ClassDescriptor>());
                }
                break;
            }
        }
        catch (MissingClassException e) {
            TypeQualifierResolver.logMissingAnnotationClass(e);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error resolving " + value.getAnnotationClass(), e);
        }
        catch (ClassCastException e) {
            AnalysisContext.logError("ClassCastException " + value.getAnnotationClass(), e);
        }
    }
}

