package de.ugoe.cs.eventbench.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;

import de.ugoe.cs.eventbench.data.Event;

public class InsertAssertionDialog extends Dialog {

	protected Event<?> result;
	protected Shell shell;
	
	private TabFolder tabFolder;
	
	List<AbstractInsertEventComposite> insertEventComposites;
	SortedSet<String> targets;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public InsertAssertionDialog(Shell parent, int style, SortedSet<String> targets) {
		super(parent, style);
		setText("SWT Dialog");
		this.targets = targets;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Event<?> open() {
		result = null;
		insertEventComposites = new ArrayList<AbstractInsertEventComposite>();
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), SWT.SHELL_TRIM | SWT.BORDER | SWT.APPLICATION_MODAL);
		shell.setSize(450, 300);
		shell.setText(getText());
		shell.setLayout(new GridLayout(2, false));
		
		tabFolder = new TabFolder(shell, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		
		TabItem tbtmTextEquals = new TabItem(tabFolder, SWT.NONE);
		tbtmTextEquals.setText("TextEquals");
		AbstractInsertEventComposite compTextEquals = new InsertTextEquals(tabFolder, SWT.NO_BACKGROUND, targets);
		tbtmTextEquals.setControl(compTextEquals);
		insertEventComposites.add(compTextEquals);
		
		TabItem tbtmFileEquals = new TabItem(tabFolder, SWT.NONE);
		tbtmFileEquals.setText("FileEquals");
		AbstractInsertEventComposite compFileEquals = new InsertFileEquals(tabFolder, SWT.NO_BACKGROUND, targets);
		tbtmFileEquals.setControl(compFileEquals);
		insertEventComposites.add(compFileEquals);
		
		Button btnInsert = new Button(shell, SWT.NONE);
		btnInsert.setText("Insert");
		btnInsert.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int index = tabFolder.getSelectionIndex();
				result = insertEventComposites.get(index).getEvent();
				shell.dispose();
			}
		});
		
		Button btnAbort = new Button(shell, SWT.NONE);
		btnAbort.setText("Abort");
		btnAbort.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.dispose();
			}
		});
	}
}
