package de.ugoe.cs.eventbench.jfc.data;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>JFCEventTest</code> contains tests for the class <code>{@link JFCEvent}</code>.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
public class JFCEventTest {
	
	@Test
	public void testTargetEquals_1()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_2()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['titleOther','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_3()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hashOther']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_4()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['titleOther','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_5()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hashOther'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_6()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['titleOther','class2','text2','index2','hashOther']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_7()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['titleOther','class1','text1','index1','hashOther'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_8()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','classOther','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_9()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','class2','textOther','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_10()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','indexOther','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_11()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','classOther','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_12()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','textOther','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_13()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title1','class1','text1','indexOther','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_14()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title'1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title'1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_15()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title]1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title]1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_16()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title[1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title[1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_17()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title].1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title].1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_18()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title.[1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		String target2 = "['title.[1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_19()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = "['title1','class1','text1','index1','hash1'].['title2','class2','text2','index2','hash2']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_20()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = "['title1','class1','text1','index1','hash1']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_21()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = "['titleOther','class1','text1','index1','hash1']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_22()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = "['title1','class1','text1','index1','hashOther']";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_23()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = "['titleOther','class1','text1','index1','hashOther']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_24()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = null;
		String target2 = "['titleOther','class1','text1','index1','hash1']";
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_25()
		throws Exception {
		JFCEvent event = new JFCEvent("type");
		String target1 = "['title1','class1','text1','index1','hash1']";
		String target2 = null;
		event.setTarget(target1);
		boolean expected = false;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	
	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(JFCEventTest.class);
	}
}