package de.ugoe.cs.eventbench.data;

import java.util.HashMap;
import java.util.Map;

public class GlobalDataContainer {
	
	private static GlobalDataContainer theInstance= null;
	
	private Map<String, Object> dataObjects;
	
	public static GlobalDataContainer getInstance() {
		if( theInstance==null ) {
			theInstance = new GlobalDataContainer();
		}
		return theInstance;
	}
	
	private GlobalDataContainer() {
		dataObjects = new HashMap<String, Object>();
	}
	
	public boolean addData(String key, Object data) {
		Object previousEntry = dataObjects.put(key, data);
		return previousEntry!=null;
	}
	
	public boolean removeData(String key) {
		Object previousEntry = dataObjects.remove(key);
		return previousEntry==null;
	}
	
	public Object getData(String key) {
		return dataObjects.get(key);
	}
	
	public void reset() {
		dataObjects = new HashMap<String, Object>();
	}

}
