package de.ugoe.cs.eventbench;

import java.io.IOException;
import java.util.List;

import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import de.ugoe.cs.eventbench.log4j.Log4JLogger;
import de.ugoe.cs.eventbench.swt.MainWindow;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * Start-up class of the application.
 * </p>
 * <p>
 * It sets up and starts the {@link Console}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class Runner {

	public enum UITYPE {
		text, swt
	};

	/**
	 * <p>
	 * Main method of the application.
	 * </p>
	 * 
	 * @param args
	 *            if parameters are defined, they are interpreted as commands
	 *            for the {@link Console} and executed before the user can use
	 *            the console; can be used to perform batch operations
	 */
	public static void main(String[] args) {
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.windows.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.web.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.efg.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.eventbench.jfc.commands");
		new Log4JLogger();

		OptionParser parser = new OptionParser();
		OptionSpec<UITYPE> ui = parser.accepts("ui", "Allowed values: text, swt").withRequiredArg()
				.ofType(UITYPE.class).defaultsTo(UITYPE.text);
		OptionSet options = parser.parse(args);

		List<String> startupCommands = options.nonOptionArguments();
		try {
		switch (options.valueOf(ui)) {
		case text:
			TextConsole textConsole = new TextConsole();
			for (String command : startupCommands) {
				CommandExecuter.getInstance().exec(command);
			}
			textConsole.run(true);
			break;
		case swt:
			MainWindow mainWindow = new MainWindow(startupCommands);
			mainWindow.open();
			break;
		}
		} catch (OptionException e) {
			System.err.println("Invalid Parameters: " + e.getMessage());
			try {
				parser.printHelpOn(System.out);
			} catch (IOException e1) {
				// ignore exception.
			}
		}
	}

}
