package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.ReplayGenerator;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.ReplayableEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDgenerateReplayfile implements Command {

	@Override
	public void help() {
		Console.println("Usage: generateReplayfile <filename>");		
	}

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		if( parameters.size() < 1 ) {
			throw new InvalidParameterException();
		}
		String filename = (String) parameters.get(0);
		
		List<List<ReplayableEvent<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData("sequences");
			
		try {
			sequences = (List<List<ReplayableEvent<?>>>) dataObject;
			ReplayGenerator generator = new ReplayGenerator();
			if( sequences.size()>0 ) {
				if( sequences.get(0).get(0) instanceof Event ) {
					generator.createLogfileMultipleSessions(sequences, filename);
				} else {
					Console.traceln("Illegal use of \"sequences\" parameter in the GlobalDataContainer.");
					Console.traceln("The parameter should always be of type List<List<Event>>!");
				}
			}
		}
		catch(ClassCastException e) {
			Console.printerrln("Sequences need to be loaded first using parseXML");
		}
		
	}

}
