/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model;

import edu.umd.cs.guitar.util.GUITARLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class IO {
    public static Object readObjFromFile(InputStream is, Class<?> cls) {
        Object retObj = null;
        try {
            String packageName = cls.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            Unmarshaller u = jc.createUnmarshaller();
            retObj = u.unmarshal((Reader)isr);
        }
        catch (JAXBException e) {
            GUITARLog.log.error((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retObj;
    }

    public static Object readObjFromFile(String sFileName, Class<?> cls) {
        Object retObj = null;
        try {
            File file = new File(sFileName);
            FileInputStream fis = new FileInputStream(file);
            retObj = IO.readObjFromFile(fis, cls);
        }
        catch (FileNotFoundException e) {
            GUITARLog.log.error((Object)(sFileName + " not found!!!"));
        }
        return retObj;
    }

    public static void writeObjToFile(Object object, OutputStream os) {
        String packageName = object.getClass().getPackage().getName();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, os);
            os.close();
        }
        catch (JAXBException e) {
            GUITARLog.log.error((Object)e);
        }
        catch (IOException e) {
            GUITARLog.log.error((Object)e);
        }
    }

    public static void writeObjToFile(Object object, String sFileName) {
        try {
            IO.writeObjToFile(object, new FileOutputStream(sFileName));
        }
        catch (FileNotFoundException e) {
            GUITARLog.log.error((Object)(sFileName + " NOT FOUND!!!"));
        }
    }
}

