package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class AboutDialog extends Dialog {

	protected Shell shlAboutEventbenchconsole;
	private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public AboutDialog(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 */
	public void open() {
		createContents();
		shlAboutEventbenchconsole.open();
		shlAboutEventbenchconsole.layout();
		Display display = getParent().getDisplay();
		while (!shlAboutEventbenchconsole.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shlAboutEventbenchconsole = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shlAboutEventbenchconsole.setSize(283, 113);
		shlAboutEventbenchconsole.setText("About EventBenchConsole");
		
		Label lblEventbenchconsole = new Label(shlAboutEventbenchconsole, SWT.CENTER);
		lblEventbenchconsole.setBounds(10, 10, 267, 15);
		lblEventbenchconsole.setText("EventBenchConsole");
		
		Label lblFurtherInformationAbout = new Label(shlAboutEventbenchconsole, SWT.WRAP);
		lblFurtherInformationAbout.setBounds(10, 31, 267, 31);
		lblFurtherInformationAbout.setText("Further information about this software is provided on our homepage.");
		
		final Hyperlink hprlnkHttpeventbenchinformatikunigoettingende = formToolkit.createHyperlink(shlAboutEventbenchconsole, "http://eventbench.informatik.uni-goettingen.de", SWT.NONE);
		hprlnkHttpeventbenchinformatikunigoettingende.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				Program.launch(hprlnkHttpeventbenchinformatikunigoettingende.getText());
			}
		});
		hprlnkHttpeventbenchinformatikunigoettingende.setBounds(10, 68, 267, 17);
		formToolkit.paintBordersFor(hprlnkHttpeventbenchinformatikunigoettingende);
		hprlnkHttpeventbenchinformatikunigoettingende.setBackground(null);

	}
}
