/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.workflow.Filter;
import edu.umd.cs.findbugs.workflow.RecursiveSearchForJavaFiles;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;

public class SetBugDatabaseInfo {
    private static final String USAGE = "Usage: <cmd>  [options] [<oldData> [<newData>]]";
    static SourceSearcher sourceSearcher;

    public static void main(String[] args) throws IOException, DocumentException {
        long last;
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        SetInfoCommandLine commandLine = new SetInfoCommandLine();
        int argCount = commandLine.parse(args, 0, 2, USAGE);
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount < args.length) {
            origCollection.readXML(args[argCount++]);
        } else {
            origCollection.readXML(System.in);
        }
        Project project = origCollection.getProject();
        if (commandLine.revisionName != null) {
            origCollection.setReleaseName(commandLine.revisionName);
        }
        if (commandLine.projectName != null) {
            origCollection.getProject().setProjectName(commandLine.projectName);
        }
        if (commandLine.revisionTimestamp != 0L) {
            origCollection.setTimestamp(commandLine.revisionTimestamp);
        }
        origCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.purgeDesignations) {
            for (BugInstance b : origCollection) {
                b.setUserDesignation(null);
            }
        }
        if (commandLine.exclusionFilterFile != null) {
            project.setSuppressionFilter(Filter.parseFilter(commandLine.exclusionFilterFile));
        }
        if (commandLine.resetProject) {
            project.getSourceDirList().clear();
            project.getFileList().clear();
            project.getAuxClasspathEntryList().clear();
        }
        boolean reinitializeCloud = false;
        if (commandLine.cloudId != null) {
            project.setCloudId(commandLine.cloudId);
            reinitializeCloud = true;
        }
        for (Map.Entry<String, String> e : commandLine.cloudProperties.entrySet()) {
            project.getCloudProperties().setProperty(e.getKey(), e.getValue());
            reinitializeCloud = true;
        }
        if (commandLine.resetSource) {
            project.getSourceDirList().clear();
        }
        for (String source : commandLine.sourcePaths) {
            project.addSourceDir(source);
        }
        if (commandLine.purgeStats) {
            origCollection.getProjectStats().getPackageStats().clear();
        }
        if (commandLine.purgeClassStats) {
            for (PackageStats ps : origCollection.getProjectStats().getPackageStats()) {
                ps.getClassStats().clear();
            }
        }
        if (commandLine.purgeMissingClasses) {
            origCollection.clearMissingClasses();
        }
        if (commandLine.lastVersion != null && (last = Filter.FilterCommandLine.getVersionNum(origCollection, commandLine.lastVersion, true)) < origCollection.getSequenceNumber()) {
            String name = origCollection.getAppVersionFromSequenceNumber(last).getReleaseName();
            long timestamp = origCollection.getAppVersionFromSequenceNumber(last).getTimestamp();
            origCollection.setReleaseName(name);
            origCollection.setTimestamp(timestamp);
            origCollection.trimAppVersions(last);
        }
        HashMap missingFiles = new HashMap();
        if (!commandLine.searchSourcePaths.isEmpty()) {
            sourceSearcher = new SourceSearcher(project);
            for (BugInstance bug : origCollection.getCollection()) {
                SourceLineAnnotation src = bug.getPrimarySourceLineAnnotation();
                if (SetBugDatabaseInfo.sourceSearcher.sourceNotFound.contains(src.getClassName()) || sourceSearcher.findSource(src)) continue;
                HashSet<String> paths = (HashSet<String>)missingFiles.get(src.getSourceFile());
                if (paths == null) {
                    paths = new HashSet<String>();
                    missingFiles.put(src.getSourceFile(), paths);
                }
                String fullPath = SetBugDatabaseInfo.fullPath(src);
                paths.add(fullPath);
            }
            HashSet<String> foundPaths = new HashSet<String>();
            for (String f : commandLine.searchSourcePaths) {
                for (File javaFile : RecursiveSearchForJavaFiles.search(new File(f))) {
                    Set matchingMissingClasses = (Set)missingFiles.get(javaFile.getName());
                    if (matchingMissingClasses == null) continue;
                    for (String sourcePath : matchingMissingClasses) {
                        String path = javaFile.getAbsolutePath();
                        if (!path.endsWith(sourcePath)) continue;
                        String dir = path.substring(0, path.length() - sourcePath.length());
                        foundPaths.add(dir);
                    }
                }
            }
            HashSet<String> toRemove = new HashSet<String>();
            block8: for (String p1 : foundPaths) {
                for (String p2 : foundPaths) {
                    if (p1.equals(p2) || !p1.startsWith(p2)) continue;
                    toRemove.add(p1);
                    continue block8;
                }
            }
            foundPaths.removeAll(toRemove);
            for (String dir : foundPaths) {
                project.addSourceDir(dir);
                if (argCount >= args.length) continue;
                System.out.println("Found " + dir);
            }
        }
        if (reinitializeCloud) {
            origCollection.clearCloud();
        }
        if (argCount < args.length) {
            origCollection.writeXML(args[argCount++]);
        } else {
            origCollection.writeXML(System.out);
        }
    }

    static String fullPath(SourceLineAnnotation src) {
        return src.getPackageName().replace('.', File.separatorChar) + File.separatorChar + src.getSourceFile();
    }

    static class SetInfoCommandLine
    extends CommandLine {
        String revisionName;
        String projectName;
        String exclusionFilterFile;
        String lastVersion;
        String cloudId;
        HashMap<String, String> cloudProperties = new HashMap();
        boolean withMessages = false;
        boolean purgeStats = false;
        boolean purgeClassStats = false;
        boolean purgeMissingClasses = false;
        boolean resetSource = false;
        boolean resetProject = false;
        boolean purgeDesignations = false;
        long revisionTimestamp = 0L;
        public List<String> sourcePaths = new LinkedList<String>();
        public List<String> searchSourcePaths = new LinkedList<String>();

        SetInfoCommandLine() {
            this.addOption("-name", "name", "set name for (last) revision");
            this.addOption("-projectName", "name", "set name for project");
            this.addOption("-timestamp", "when", "set timestamp for (last) revision");
            this.addSwitch("-resetSource", "remove all source search paths");
            this.addSwitch("-resetProject", "remove all source search paths, analysis and auxilary classpath entries");
            this.addOption("-source", "directory", "Add this directory to the source search path");
            this.addSwitch("-purgeStats", "purge/delete information about sizes of analyzed class files");
            this.addSwitch("-uploadDesignations", "upload all designations to cloud");
            this.addSwitch("-purgeDesignations", "purge/delete user designations (e.g., MUST_FIX or NOT_A_BUG");
            this.addSwitch("-purgeClassStats", "purge/delete information about sizes of analyzed class files, but retain class stats");
            this.addSwitch("-purgeMissingClasses", "purge list of missing classes");
            this.addOption("-findSource", "directory", "Find and add all relevant source directions contained within this directory");
            this.addOption("-suppress", "filter file", "Suppress warnings matched by this file (replaces previous suppressions)");
            this.addOption("-lastVersion", "version", "Trim the history to just include just the specified version");
            this.addSwitch("-withMessages", "Add bug descriptions");
            this.addOption("-cloud", "id", "set cloud id");
            this.addOption("-cloudProperty", "key=value", "set cloud property");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-withMessages")) {
                this.withMessages = true;
            } else if (option.equals("-resetSource")) {
                this.resetSource = true;
            } else if (option.equals("-resetProject")) {
                this.resetProject = true;
            } else if (option.equals("-purgeStats")) {
                this.purgeStats = true;
            } else if (option.equals("-purgeDesignations")) {
                this.purgeDesignations = true;
            } else if (option.equals("-purgeClassStats")) {
                this.purgeClassStats = true;
            } else if (option.equals("-purgeMissingClasses")) {
                this.purgeMissingClasses = true;
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-name")) {
                this.revisionName = argument;
            } else if (option.equals("-cloud")) {
                this.cloudId = argument;
            } else if (option.equals("-cloudProperty")) {
                int e = argument.indexOf(61);
                if (e == -1) {
                    throw new IllegalArgumentException("Bad cloud property: " + argument);
                }
                String key = argument.substring(0, e);
                String value = argument.substring(e + 1);
                this.cloudProperties.put(key, value);
            } else if (option.equals("-projectName")) {
                this.projectName = argument;
            } else if (option.equals("-suppress")) {
                this.exclusionFilterFile = argument;
            } else if (option.equals("-timestamp")) {
                this.revisionTimestamp = Date.parse(argument);
            } else if (option.equals("-source")) {
                this.sourcePaths.add(argument);
            } else if (option.equals("-lastVersion")) {
                this.lastVersion = argument;
            } else if (option.equals("-findSource")) {
                this.searchSourcePaths.add(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

