package de.ugoe.cs.quest.models;

import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

/**
 * The class <code>TestAll</code> builds a suite that can be used to run all
 * of the tests within its package as well as within any subpackages of its
 * package.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
@RunWith(Suite.class)
@Suite.SuiteClasses({
	DeterministicFiniteAutomatonTest.class,
	FirstOrderMarkovModelTest.class,
	HighOrderMarkovModelTest.class,
	IncompleteMemoryTest.class,
	ModelFlattenerTest.class,
	PredictionByPartialMatchTest.class,
	TrieBasedModelTest.class,	
	TrieTest.class
})
public class TestAll {

	public static void main(String[] args) {
		JUnitCore.runClasses(new Class[] { TestAll.class });
	}
}
