package de.ugoe.cs.quest.data;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

import org.junit.*;

import de.ugoe.cs.quest.data.Event;
import de.ugoe.cs.quest.data.ReplayableEvent;

import static org.junit.Assert.*;

/**
 * The class <code>EventTest</code> contains tests for the class
 * <code>{@link Event}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class EventTest {

	@Test
	public void testEvent_1() throws Exception {
		String type = "typeString";

		Event<String> result = new Event<String>(type);

		assertNotNull(result);
		assertEquals(type, result.type);
		assertNull(result.target);
		assertNull(result.targetShort);
		assertEquals("", result.idInfo);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testEvent_2() throws Exception {
		new Event<String>(null);
	}

	@Test
	public void testEquals_1() throws Exception {
		String type1 = "typeString";
		String type2 = "typeString";
		Event<String> fixture = new Event<String>(type1);
		Event<String> other = new Event<String>(type2);

		boolean result = fixture.equals(other);

		assertTrue(result);
	}

	@Test
	public void testEquals_2() throws Exception {
		String type1 = "typeString1";
		String type2 = "typeString2";
		Event<String> fixture = new Event<String>(type1);
		Event<String> other = new Event<String>(type2);

		boolean result = fixture.equals(other);

		assertFalse(result);
	}

	@Test
	public void testEquals_3() throws Exception {
		String type1 = "typeString";
		String type2 = "typeString";
		String target1 = "target";
		String target2 = "target";
		Event<String> fixture = new Event<String>(type1);
		fixture.target = target1;
		Event<String> other = new Event<String>(type2);
		other.target = target2;

		boolean result = fixture.equals(other);

		assertTrue(result);
	}

	@Test
	public void testEquals_4() throws Exception {
		String type1 = "typeString1";
		String type2 = "typeString2";
		String target1 = "target";
		String target2 = "target";
		Event<String> fixture = new Event<String>(type1);
		fixture.target = target1;
		Event<String> other = new Event<String>(type2);
		other.target = target2;

		boolean result = fixture.equals(other);

		assertFalse(result);
	}

	@Test
	public void testEquals_5() throws Exception {
		String type1 = "typeString";
		String type2 = "typeString";
		String target1 = "target1";
		String target2 = "target2";
		Event<String> fixture = new Event<String>(type1);
		fixture.target = target1;
		Event<String> other = new Event<String>(type2);
		other.target = target2;

		boolean result = fixture.equals(other);

		assertFalse(result);
	}

	@Test
	public void testEquals_6() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		boolean result = fixture.equals(fixture);

		assertTrue(result);
	}

	@Test
	public void testEqualsContract() throws Exception {
		EqualsVerifier.forClass(Event.class)
				.suppress(Warning.NONFINAL_FIELDS).withRedefinedSubclass(ReplayableEvent.class)
				.verify();
	}

	@Test
	public void testGetIdInfo_fixture_1() throws Exception {
		String type = "typeString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.idInfo = idInfo;

		String result = fixture.getIdInfo();

		assertEquals(idInfo, result);
	}

	@Test
	public void testGetShortId_1() throws Exception {
		String type = "typeString";
		String targetShort = "targetShortString";
		Event<String> fixture = new Event<String>(type);
		fixture.targetShort = targetShort;

		String result = fixture.getShortId();

		assertEquals("targetShortString.typeString", result);
	}

	@Test
	public void testGetShortId_2() throws Exception {
		String type = "typeString";
		String targetShort = "targetShortString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.targetShort = targetShort;
		fixture.idInfo = idInfo;

		String result = fixture.getShortId();

		assertEquals("targetShortString.typeString.idInfoString", result);
	}

	@Test
	public void testGetShortId_3() throws Exception {
		String type = "typeString";
		String target = "targetString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;

		String result = fixture.getShortId();

		assertEquals("targetString.typeString", result);
	}

	@Test
	public void testGetStandardId_1() throws Exception {
		String type = "typeString";
		String target = "targetString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;

		String result = fixture.getStandardId();

		assertEquals("targetString.typeString", result);
	}

	@Test
	public void testGetStandardId_2() throws Exception {
		String type = "typeString";
		String target = "targetString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;
		fixture.idInfo = idInfo;

		String result = fixture.getStandardId();

		assertEquals("targetString.typeString.idInfoString", result);
	}

	@Test
	public void testGetStandardId_3() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		String result = fixture.getStandardId();

		assertEquals("typeString", result);
	}

	@Test
	public void testGetStandardId_4() throws Exception {
		String type = "typeString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.idInfo = idInfo;

		String result = fixture.getStandardId();

		assertEquals("typeString.idInfoString", result);
	}

	@Test
	public void testGetTarget_1() throws Exception {
		String type = "typeString";
		String target = "targetString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;

		String result = fixture.getTarget();

		assertEquals(target, result);
	}

	@Test
	public void testGetTarget_2() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		String result = fixture.getTarget();

		assertNull(result);
	}

	@Test
	public void testGetTargetShort_1() throws Exception {
		String type = "typeString";
		String targetShort = "targetShort";
		Event<String> fixture = new Event<String>(type);
		fixture.targetShort = targetShort;

		String result = fixture.getTargetShort();

		assertEquals(targetShort, result);
	}

	@Test
	public void testGetTargetShort_2() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		String result = fixture.getTargetShort();

		assertNull(result);
	}

	@Test
	public void testGetType_1() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		String result = fixture.getType();

		assertEquals(type, result);
	}

	@Test
	public void testSetIdInfo_fixture_1() throws Exception {
		String type = "typeString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);

		fixture.setIdInfo(idInfo);

		assertEquals(idInfo, fixture.idInfo);
	}

	@Test
	public void testSetIdInfo_2() throws Exception {
		String type = "typeString";
		String idInfo = null;
		Event<String> fixture = new Event<String>(type);

		fixture.setIdInfo(idInfo);

		assertEquals(idInfo, fixture.idInfo);
	}

	@Test
	public void testSetTarget_1() throws Exception {
		String type = "typeString";
		String target = "targetString";
		Event<String> fixture = new Event<String>(type);

		boolean result = fixture.setTarget(target);

		assertTrue(result);
		assertEquals(target, fixture.target);
	}

	@Test
	public void testSetTarget_2() throws Exception {
		String type = "typeString";
		String target1 = "targetString1";
		String target2 = "targetString2";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target1;

		boolean result = fixture.setTarget(target2);

		assertFalse(result);
		assertEquals(target1, fixture.target);
	}

	@Test
	public void testSetTargetShort_1() throws Exception {
		String type = "typeString";
		String targetShort = "targetShortString";
		Event<String> fixture = new Event<String>(type);

		boolean result = fixture.setTargetShort(targetShort);

		assertTrue(result);
		assertEquals(targetShort, fixture.targetShort);
	}

	@Test
	public void testSetTargetShort_2() throws Exception {
		String type = "typeString";
		String targetShort1 = "targetShortString1";
		String targetShort2 = "targetShortString2";
		Event<String> fixture = new Event<String>(type);
		fixture.targetShort = targetShort1;

		boolean result = fixture.setTargetShort(targetShort2);

		assertFalse(result);
		assertEquals(targetShort1, fixture.targetShort);
	}

	@Test
	public void testToString_1() throws Exception {
		String type = "typeString";
		String target = "targetString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;

		String result = fixture.toString();

		assertEquals("targetString.typeString", result);
	}

	@Test
	public void testToString_2() throws Exception {
		String type = "typeString";
		String target = "targetString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.target = target;
		fixture.idInfo = idInfo;

		String result = fixture.toString();

		assertEquals("targetString.typeString.idInfoString", result);
	}

	@Test
	public void testToString_3() throws Exception {
		String type = "typeString";
		Event<String> fixture = new Event<String>(type);

		String result = fixture.toString();

		assertEquals("typeString", result);
	}

	@Test
	public void testToString_4() throws Exception {
		String type = "typeString";
		String idInfo = "idInfoString";
		Event<String> fixture = new Event<String>(type);
		fixture.idInfo = idInfo;

		String result = fixture.toString();

		assertEquals("typeString.idInfoString", result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(EventTest.class);
	}
}