package de.ugoe.cs.quest.data;

import java.io.Serializable;

/**
 * <p>
 * This interface is used by {@link ReplayableEvent}to describe how events can
 * be replayed. It can be used to define a sequence of fine-grained platform
 * events that make up an abstract event.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IReplayable extends Serializable {

	/**
	 * <p>
	 * Returns a string to be written to the replay script that describes the
	 * replayable platform event.
	 * </p>
	 * 
	 * @return string for the replay script
	 */
	String getReplay();

	/**
	 * <p>
	 * Returns the target of the replayable.
	 * </p>
	 * 
	 * @return target of the replayable
	 */
	String getTarget();
}
