package de.ugoe.cs.quest.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.FileOutputListener;

/**
 * <p>
 * Command to start a {@link FileOutputListener}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDstartFileListener implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		FileOutputListener listener = new FileOutputListener(filename);
		listener.start();
		if (GlobalDataContainer.getInstance().addData(filename, listener)) {
			CommandHelpers.dataOverwritten(filename);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: startFileListener <filename>");
	}

}
