package de.ugoe.cs.quest.commands;

import java.util.List;
import java.util.Random;

import de.ugoe.cs.quest.models.FirstOrderMarkovModel;
import de.ugoe.cs.quest.models.HighOrderMarkovModel;
import de.ugoe.cs.quest.models.TrieBasedModel;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to train first-order and high-order Markov models.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 2.0
 */
public class CMDtrainMarkovModel extends AbstractTrainCommand {

	/**
	 * <p>
	 * Order of the Markov model.
	 * </p>
	 */
	int order;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: trainMarkovModel <modelName> <sequencesName> {<order>}");
	}

	/**
	 * <p>
	 * Handles the parameter order.
	 * </p>
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#handleOptionalParameters(java.util.List)
	 */
	@Override
	void handleAdditionalParameters(List<Object> parameters) throws Exception {
		if (parameters.size() >= 3) {
			order = Integer.parseInt((String) parameters.get(2));
		} else {
			order = 1;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#createModel()
	 */
	@Override
	TrieBasedModel createModel() {
		if (order == 1) {
			return new FirstOrderMarkovModel(new Random());
		} else {
			return new HighOrderMarkovModel(order, new Random());
		}
	}

}
