package de.ugoe.cs.quest.efg.data;

import de.ugoe.cs.quest.data.ReplayableEvent;

/**
 * <p>
 * Convenience class for working with EFGEvents.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class EFGEvent extends ReplayableEvent<EFGReplayable> {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * Constructor. Creates a new EFGEvent.
	 * </p>
	 * 
	 * @param eventId
	 *            EventId of the event in the EFG and GUI files
	 */
	public EFGEvent(String eventId) {
		super(eventId);
		this.addReplayEvent(new EFGReplayable(eventId));
	}
}
