package de.ugoe.cs.quest.commands;

import java.util.List;
import java.util.Random;

import de.ugoe.cs.quest.models.DeterministicFiniteAutomaton;
import de.ugoe.cs.quest.models.TrieBasedModel;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to train a Deterministic Finite Automaton (DFA).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 2.0
 */
public class CMDtrainDFA extends AbstractTrainCommand {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: trainDFA <modelName> <sequencesName>");
	}

	/**
	 * <p>
	 * No additional parameters.
	 * </p>
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#handleAdditionalParameters(java.util.List)
	 */
	@Override
	void handleAdditionalParameters(List<Object> parameters) throws Exception {
		// no additional parameters.
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#createModel()
	 */
	@Override
	TrieBasedModel createModel() {
		return new DeterministicFiniteAutomaton(new Random());
	}

}
