package de.ugoe.cs.quest.swt;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import de.ugoe.cs.util.console.CommandExecuter;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class GenerateSequencesDialog extends Dialog {

	private String processName;
	
	protected Button btnNumberAll;
	protected Button btnLengthAll;
	protected Spinner numberSpinner;
	protected Spinner iterationsSpinner;
	protected Spinner minLengthSpinner;
	protected Spinner maxLengthSpinner;
	
	protected Shell shlGenerateSequences;
	private Text sequencesNameText;
	private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public GenerateSequencesDialog(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 */
	public void open() {
		createContents();
		shlGenerateSequences.open();
		shlGenerateSequences.layout();
		Display display = getParent().getDisplay();
		while (!shlGenerateSequences.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shlGenerateSequences = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shlGenerateSequences.setSize(201, 303);
		shlGenerateSequences.setText("Generate Sequences");
		shlGenerateSequences.setLayout(new GridLayout(2, false));
		
		Group group = new Group(shlGenerateSequences, SWT.NONE);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		group.setText("Name");
		group.setLayout(new GridLayout(1, false));
		
		sequencesNameText = new Text(group, SWT.BORDER);
		sequencesNameText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Group grpNumber = new Group(shlGenerateSequences, SWT.NONE);
		grpNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		grpNumber.setText("Number");
		grpNumber.setLayout(new GridLayout(2, false));
		
		numberSpinner = new Spinner(grpNumber, SWT.BORDER);
		numberSpinner.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		numberSpinner.setMinimum(1);
		numberSpinner.setMaximum(Integer.MAX_VALUE);
		
		btnNumberAll = new Button(grpNumber, SWT.CHECK);
		btnNumberAll.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				numberSpinner.setEnabled(!btnNumberAll.getSelection());
				btnLengthAll.setEnabled(!btnNumberAll.getSelection());
				iterationsSpinner.setEnabled(!btnNumberAll.getSelection());
			}
		});
		btnNumberAll.setText("All");
		
		Group grpIterations = new Group(shlGenerateSequences, SWT.NONE);
		grpIterations.setLayout(new GridLayout(1, false));
		grpIterations.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpIterations.setText("Iterations");
		
		iterationsSpinner = new Spinner(grpIterations, SWT.BORDER);
		iterationsSpinner.setMinimum(1);
		iterationsSpinner.setMaximum(Integer.MAX_VALUE);
		iterationsSpinner.setSelection(100000);
		iterationsSpinner.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Group grpLength = new Group(shlGenerateSequences, SWT.NONE);
		grpLength.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpLength.setText("Length");
		grpLength.setLayout(new GridLayout(4, false));
		
		btnLengthAll = new Button(grpLength, SWT.CHECK);
		btnLengthAll.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				minLengthSpinner.setEnabled(!btnLengthAll.getSelection());
				maxLengthSpinner.setEnabled(!btnLengthAll.getSelection());
			}
		});
		btnLengthAll.setText("All");
		new Label(grpLength, SWT.NONE);
		new Label(grpLength, SWT.NONE);
		new Label(grpLength, SWT.NONE);
		
		Label label = new Label(grpLength, SWT.NONE);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label.setText("Min.");
		
		minLengthSpinner = new Spinner(grpLength, SWT.BORDER);
		minLengthSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		minLengthSpinner.setMinimum(1);
		
		Label label_1 = new Label(grpLength, SWT.NONE);
		label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, true, 1, 1));
		label_1.setText("Max.");
		
		maxLengthSpinner = new Spinner(grpLength, SWT.BORDER);
		maxLengthSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		maxLengthSpinner.setToolTipText("0 means no limitations");
		maxLengthSpinner.setMinimum(1);
		
		Button btnGenerate = formToolkit.createButton(shlGenerateSequences, "Generate!", SWT.NONE);
		btnGenerate.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if("".equals(sequencesNameText.getText())) {
					MessageBox messageBox = new MessageBox(shlGenerateSequences, SWT.ERROR);
					messageBox.setText("Error");
					messageBox.setMessage("Sequences name not defined!");
					messageBox.open();
					return;
				}
				String sequencesName = sequencesNameText.getText();
				int number = numberSpinner.getSelection();
				int minLength = minLengthSpinner.getSelection();
				int maxLength = maxLengthSpinner.getSelection();
				int maxIter = iterationsSpinner.getSelection();
				if( maxIter<=number ) {
					maxIter = number;
				}
				String command = "";
				if( btnNumberAll.getSelection() ) {
					if( minLength>maxLength ) {
						MessageBox messageBox = new MessageBox(shlGenerateSequences, SWT.ERROR);
						messageBox.setText("Error");
						messageBox.setMessage("Min. length must be smaller than or equal to max. length!");
						messageBox.open();
						return;
					}
					command = "generateFixedLengthSequences " + processName + " " + sequencesName + " " + minLength + " " + maxLength + " true";
				} else {
					command = "generateRandomSequences " + processName + " " + sequencesName + " " + number + " " + maxIter;
					if( !btnLengthAll.getSelection() ) {
						if( minLength>maxLength ) {
							MessageBox messageBox = new MessageBox(shlGenerateSequences, SWT.ERROR);
							messageBox.setText("Error");
							messageBox.setMessage("Min. length must be smaller than or equal to max. length!");
							messageBox.open();
							return;
						}
						command += " " + minLength + " " + maxLength;
					}
				}
				CommandExecuter.getInstance().exec(command);
				shlGenerateSequences.dispose();
			}
		});
		
		Button btnAbort = formToolkit.createButton(shlGenerateSequences, "Abort", SWT.NONE);
		btnAbort.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shlGenerateSequences.dispose();
			}
		});

	}
	
	public void setProcessName(String name) {
		this.processName = name;
	}
}
