package de.ugoe.cs.quest.commands;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.data.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to list all events (symbols) known to a usage profile (stochastic
 * process).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDlistSymbols implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		boolean sort = false;
		try {
			modelname = (String) parameters.get(0);
			if (parameters.size() == 2) {
				sort = Boolean.parseBoolean((String) parameters.get(1));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof IStochasticProcess)) {
			CommandHelpers.objectNotType(modelname, "IStochasticProcess");
			return;
		}
		model = (IStochasticProcess) dataObject;
		String[] stateStrings = model.getSymbolStrings();
		if (sort) {
			Arrays.sort(stateStrings);
		}
		for (String stateString : stateStrings) {
			Console.println(stateString);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: listStates <modelName> {<sort>}");
	}

}
