package de.ugoe.cs.quest.efg.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.data.GlobalDataContainer;
import de.ugoe.cs.quest.efg.EFGModelGenerator;
import de.ugoe.cs.quest.usageprofiles.DeterministicFiniteAutomaton;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to that loads an EFG and creates Deterministic Finite Automaton (DFA)
 * with the same structure.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgToDFA implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String modelname;
		try {
			filename = (String) parameters.get(0);
			modelname = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		EFGModelGenerator modelGenerator = new EFGModelGenerator();
		DeterministicFiniteAutomaton model = modelGenerator
				.efgToDeterministicFiniteAutomaton(filename);
		GlobalDataContainer.getInstance().addData(modelname, model);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: efgToDFA <filename> <modelname>");
	}

}
