package de.ugoe.cs.quest.swt;

import org.eclipse.swt.widgets.Composite;


import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.ugoe.cs.quest.data.GlobalDataContainer;
import de.ugoe.cs.util.console.CommandExecuter;

public class SequencesTabComposite extends Composite {
	
	protected List sequenceList;
	
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public SequencesTabComposite(Composite parent, int style) {
		super(parent, style);
		createContents();
	}

	private void createContents() {
		setLayout(new GridLayout(5, false));
		
		sequenceList = new List(this, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		sequenceList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		sequenceList.setItems(new String[] {});
		
		Button btnEdit = new Button(this, SWT.NONE);
		btnEdit.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String[] selectedSequences = sequenceList.getSelection();
				if( selectedSequences.length==0 ) {
					SWTHelpers.noSelectionError(getShell());
				} 
				else if(selectedSequences.length>1) {
					MessageBox messageBox = new MessageBox(getShell(), SWT.ERROR);
					messageBox.setMessage("Only one sequence can be edited at a time!");
					messageBox.setText("Error");
					messageBox.open();
				} else {
					SequencesDialog sequencesDialog = new SequencesDialog(getShell(), SWT.NONE);
					sequencesDialog.open(selectedSequences[0]);
				}
			}
		});
		btnEdit.setText("Edit");
		
		Button btnDelete = new Button(this, SWT.NONE);
		btnDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if( SWTHelpers.deleteSelectedFromStorage(sequenceList)) {
					updateSequenceList();
				} else {
					SWTHelpers.noSelectionError(getShell());
				}
			}
		});
		btnDelete.setText("Delete");
		
		Button btnReplay = new Button(this, SWT.NONE);
		btnReplay.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String[] selectedSequences = sequenceList.getSelection();
				if( selectedSequences.length==0 ) {
					SWTHelpers.noSelectionError(getShell());
				} else {
					StringBuilder commandString = new StringBuilder("generateReplayfile ");
					FileDialog fileDialog = new FileDialog(getShell());
					String filename = fileDialog.open();
					commandString.append(filename + " ");
					for( String selected : selectedSequences ) {
						commandString.append(selected + " ");
					}
					CommandExecuter.getInstance().exec(commandString.toString().trim());
				}
			}
		});
		btnReplay.setText("Replay");
		
		Button btnTrainModel = new Button(this, SWT.NONE);
		btnTrainModel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String[] selectedSequences = sequenceList.getSelection();
				if( selectedSequences.length==0 ) {
					SWTHelpers.noSelectionError(getShell());
				} else {
					TrainModelDialog trainDialog = new TrainModelDialog(getShell(), SWT.NONE);
					trainDialog.setSequenceNames(selectedSequences);
					trainDialog.open();
				}
			}
		});
		btnTrainModel.setText("Train Model");
		
		Button btnParse = new Button(this, SWT.NONE);
		btnParse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO implement parsing of sequences
				MessageBox messageBox = new MessageBox(getShell(), SWT.ICON_INFORMATION);
				messageBox.setText("Not implemented!");
				messageBox.setMessage("Sorry! This functionality has not been implemented yet!");
				messageBox.open();
			}
		});
		btnParse.setText("Parse");
	}
	
	public void updateSequenceList() {
		sequenceList.removeAll();
		for( String sequencesName : GlobalDataContainer.getInstance().getAllSequencesNames() ) {
			sequenceList.add(sequencesName);
		}
	}
	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
