package de.ugoe.cs.quest.windows;

import de.ugoe.cs.quest.windows.data.WindowTree;

/**
 * <p>
 * Handler for {@code WM_DESTROY} message. The handler maintains the
 * {@link WindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerDestroy extends MessageHandler {

	/**
	 * <p>
	 * Constructor. Creates a new HandlerDestroy.
	 * </p>
	 */
	public HandlerDestroy() {
		super();
	}

	/**
	 * <p>
	 * HWND of the window that is destroyed.
	 * </p>
	 */
	private int hwnd;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.windows.MessageHandler#onEndElement()
	 */
	@Override
	public void onEndElement() {
		if (hwnd != 0) {
			WindowTree.getInstance().remove(hwnd);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.quest.windows.MessageHandler#onParameter(java.lang.String
	 * , java.lang.String)
	 */
	@Override
	public void onParameter(String name, String value) {
		if (name.equals("window.hwnd")) {
			hwnd = Integer.parseInt(value);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.windows.MessageHandler#onStartElement()
	 */
	@Override
	public void onStartElement() {
		hwnd = 0;
	}

}
