package de.ugoe.cs.quest.commands;

import java.util.List;
import java.util.Random;

import de.ugoe.cs.quest.usageprofiles.PredictionByPartialMatch;
import de.ugoe.cs.quest.usageprofiles.TrieBasedModel;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that trains Prediction by Partial Match (PPM) models.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 2.0
 */
public class CMDtrainPPM extends AbstractTrainCommand {

	/**
	 * <p>
	 * Escape probability of the PPM model.
	 * </p>
	 */
	double probEscape;

	/**
	 * <p>
	 * Maximal Markov order of the PPM model.
	 * </p>
	 */
	int maxOrder;

	/**
	 * <p>
	 * Minimal Markov order of the PPM model. Default: 0
	 * </p>
	 */
	int minOrder = 0;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: trainPPM <modelName> <sequencesName> <probEscape> <maxOrder> {<minOrder>}");
	}

	/**
	 * <p>
	 * Handles the parameters probEscape, maxOrder, and minOrder.
	 * </p>
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#handleOptionalParameters(java.util.List)
	 */
	@Override
	void handleAdditionalParameters(List<Object> parameters) throws Exception {
		probEscape = Double.parseDouble((String) parameters.get(2));
		maxOrder = Integer.parseInt((String) parameters.get(3));
		if (parameters.size() == 5) {
			minOrder = Integer.parseInt((String) parameters.get(4));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.commands.AbstractTrainCommand#createModel()
	 */
	@Override
	TrieBasedModel createModel() {
		return new PredictionByPartialMatch(maxOrder, minOrder, new Random(),
				probEscape);
	}

}
