package de.ugoe.cs.quest.assertions;

import org.junit.*;

import de.ugoe.cs.quest.assertions.AssertEvent;
import de.ugoe.cs.quest.eventcore.mock.MockReplayable;
import static org.junit.Assert.*;

/**
 * The class <code>AssertEventTest</code> contains tests for the class
 * <code>{@link AssertEvent}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class AssertEventTest {

	@Test
	public void testAssertEvent_1() throws Exception {
		String type = "typeString";

		AssertEvent<MockReplayable> result = new AssertEvent<MockReplayable>(
				type);

		assertNotNull(result);
		assertEquals(type, result.getType());
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testAssertEvent_2() throws Exception {

		new AssertEvent<MockReplayable>(null);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(AssertEventTest.class);
	}
}