//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TextInputSequenceImpl.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 10.06.2012 $
// Project   : TaskTreeImpl
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.TextInputInteractionTask;
import de.ugoe.cs.tasktree.guimodel.GUIElement;
import de.ugoe.cs.tasktree.userinteraction.TextInput;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 10.06.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class TextInputInteractionTaskImpl extends InteractionTaskImpl
  implements TextInputInteractionTask
{

  /** the text, that was finally entered in this sequence without all backspaces, etc. */
  private String mEnteredText;
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param name
   */
  //-----------------------------------------------------------------------------------------------
  TextInputInteractionTaskImpl(GUIElement guiElement)
  {
    super(guiElement, new TextInput());
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeimpl.TaskTreeNodeImpl#clone()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public TextInputInteractionTaskImpl clone()
  {
    TextInputInteractionTaskImpl clone = new TextInputInteractionTaskImpl(super.getGUIElement());
    clone.setDescription(super.getDescription());
    clone.setEnteredText(this.getEnteredText());
    
    for (TaskTreeNode child : getChildren())
    {
      clone.addChild(child);
    }
    
    return clone;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TextInputSequence#getEnteredText()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public String getEnteredText()
  {
    return mEnteredText;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TextInputSequence#setEnteredText(java.lang.String)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void setEnteredText(String text)
  {
    mEnteredText = text;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized String toString()
  {
    if (super.getChildren() == null)
    {
      return super.getName();
    }
    else
    {
      return "TextInputInteraction(\"" + mEnteredText + "\", " + super.getChildren().size() +
        " children)";
    }
  }
  
}
