//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: DefaultSequenceDetectionRule.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 18.03.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.temporalrelation;

import de.ugoe.cs.quest.tasktrees.treeifc.InteractionTask;
import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNodeFactory;
import de.ugoe.cs.tasktree.guimodel.GUIElement;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 18.03.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class DefaultGUIElementSequenceDetectionRule implements TemporalRelationshipRule
{

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.temporalrelation.TemporalRelationshipRule#apply(TaskTreeNode, TaskTreeBuilder, TaskTreeNodeFactory)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public RuleApplicationResult apply(TaskTreeNode        parent,
                                     TaskTreeBuilder     builder,
                                     TaskTreeNodeFactory nodeFactory,
                                     boolean             finalize)
  {
    if (!(parent instanceof Sequence))
    {
      return null;
    }
    
    RuleApplicationResult result = new RuleApplicationResult();
    
    GUIElement currentGUIElement = null;
    int startingIndex = -1;
    
    int index = 0;
    while (index < parent.getChildren().size())
    {
      TaskTreeNode child = parent.getChildren().get(index);
      
      GUIElement guiElement = determineGUIElement(child);
      
      if ((guiElement != null) && (!guiElement.equals(currentGUIElement)))
      {
        if (startingIndex < 0)
        {
          startingIndex = index;
          currentGUIElement = guiElement;
        }
        else
        {
          handleGuiElementSequence(parent, startingIndex, index - 1, builder, nodeFactory, result);

          return result;
        }
      }
      
      index++;
    }
    
    if (startingIndex > -1)
    {
      if (finalize && (startingIndex > 0))
      {
        handleGuiElementSequence
          (parent, startingIndex, parent.getChildren().size() - 1, builder, nodeFactory, result);
      }
      else
      {
        result.setRuleApplicationStatus(RuleApplicationStatus.RULE_APPLICATION_FEASIBLE);
      }
    }
    
    return result;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param child
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  private GUIElement determineGUIElement(TaskTreeNode node)
  {
    if (node instanceof InteractionTask)
    {
      return ((InteractionTask) node).getGUIElement();
    }
    else
    {
      return null;
    }
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  private void handleGuiElementSequence(TaskTreeNode          parent,
                                        int                   startIndex,
                                        int                   endIndex,
                                        TaskTreeBuilder       builder,
                                        TaskTreeNodeFactory   nodeFactory,
                                        RuleApplicationResult result)
  {
    Sequence sequence = nodeFactory.createNewSequence();
    
    for (int i = startIndex; i <= endIndex; i++)
    {
      builder.addChild(sequence, parent.getChildren().get(startIndex));
      builder.removeChild((Sequence) parent, startIndex);
    }
    
    builder.addChild((Sequence) parent, startIndex, sequence);
    
    result.addNewlyCreatedParentNode(sequence);
    result.setRuleApplicationStatus(RuleApplicationStatus.RULE_APPLICATION_FINISHED);
  }

}
