//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTree.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 21.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.treeimpl;

import java.util.HashMap;
import java.util.Map;

import de.ugoe.cs.quest.tasktrees.treeifc.NodeInfo;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class TaskTreeImpl implements TaskTree
{
  /** the map of nodes */
  private Map<TaskTreeNode, NodeInfo> mTaskMap;
  
  /** the root node of the task tree */
  private TaskTreeNode mRootNode;
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  TaskTreeImpl(TaskTreeNode rootNode)
  {
    mRootNode = rootNode;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTree#getRoot()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public TaskTreeNode getRoot()
  {
    return mRootNode;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTree#getTaskMap()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized Map<TaskTreeNode, NodeInfo> getTaskMap()
  {
    if (mTaskMap == null)
    {
      mTaskMap = new HashMap<TaskTreeNode, NodeInfo>();
      addNodeToMap(mRootNode, null);
    }
    return mTaskMap;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param rootNode
   */
  //-----------------------------------------------------------------------------------------------
  private void addNodeToMap(TaskTreeNode node, TaskTreeNode parent)
  {
    NodeInfoImpl nodeInfo = (NodeInfoImpl) mTaskMap.get(node);
    
    if (nodeInfo == null)
    {
      nodeInfo = new NodeInfoImpl(node);
      mTaskMap.put(node, nodeInfo);
    }
    
    if (parent != null)
    {
      // through first removing an existing parent it is assured, that a parent is recorded
      // only once. This is needed, because parent may be reused in a tree as well, but we always
      // iterate the whole tree
      nodeInfo.removeParent(parent);
      nodeInfo.addParent(parent);
    }
    
    for (TaskTreeNode child : node.getChildren())
    {
      addNodeToMap(child, node);
    }
  }

}
