//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: AbstractTemporalRelationshipTC.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 28.04.2012 $
// Project   : TaskTreeTemporalRelationship
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.temporalrelation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.junit.Before;

import de.ugoe.cs.quest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.quest.tasktrees.temporalrelation.TemporalRelationshipRuleManager;
import de.ugoe.cs.quest.tasktrees.testutils.SimpleLogFormatter;
import de.ugoe.cs.quest.tasktrees.testutils.Utilities;
import de.ugoe.cs.quest.tasktrees.treeifc.InteractionTask;
import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilderImpl;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactoryImpl;
import de.ugoe.cs.tasktree.guimodel.GUIElement;
import de.ugoe.cs.tasktree.userinteraction.Interaction;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class AbstractTemporalRelationshipTC
{

  /** */
  private List<InteractionTask> mInteractions;
  
  /** */
  private TaskTreeBuilder mTaskTreeBuilder = new TaskTreeBuilderImpl();

  /** */
  private TaskTreeNodeFactory mTaskTreeNodeFactory = new TaskTreeNodeFactoryImpl();
  
  /** */
  private NodeEqualityRuleManager mNodeEqualityRuleManager =
    Utilities.getNodeEqualityRuleManagerForTests();

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Before
  public void setUp()
  {
    Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());
    mInteractions = new ArrayList<InteractionTask>();
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @param interactionsDoNotOverwriteElement
   */
  //-----------------------------------------------------------------------------------------------
  protected void simulateInteraction(GUIElement GUIElement, Interaction interaction)
  {
    mInteractions.add
      (mTaskTreeNodeFactory.createNewInteractionTask(GUIElement, interaction));
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @param interactionsDoNotOverwriteElement
   * @return 
   */
  //-----------------------------------------------------------------------------------------------
  protected TaskTree getTaskTree()
  {
    Sequence sequence = mTaskTreeNodeFactory.createNewSequence();
    
    for (InteractionTask task : mInteractions)
    {
      mTaskTreeBuilder.addChild(sequence, task);
    }
    
    TemporalRelationshipRuleManager ruleManager =
      new TemporalRelationshipRuleManager(mNodeEqualityRuleManager);
    
    ruleManager.init();
    ruleManager.applyRules(sequence, mTaskTreeBuilder, mTaskTreeNodeFactory, true);
    
    return mTaskTreeNodeFactory.createTaskTree(sequence);
  }

}
