//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTreeManagerTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 08.11.2011 21:32:36 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;
import de.ugoe.cs.tasktree.guimodel.GUIElement;
import de.ugoe.cs.tasktree.userinteraction.MouseButtonDown;
import de.ugoe.cs.tasktree.userinteraction.MouseButtonInteraction;
import de.ugoe.cs.tasktree.userinteraction.MouseButtonUp;
import de.ugoe.cs.tasktree.userinteraction.MouseClick;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------
public class DefaultMouseClickReductionRuleTest extends AbstractTemporalRelationshipTC
{
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testMouseClickInOneSequenceElement()
  {
    MouseButtonInteraction.Button leftBtn = MouseButtonInteraction.Button.LEFT;
    MouseButtonInteraction.Button middleBtn = MouseButtonInteraction.Button.MIDDLE;
    MouseButtonInteraction.Button rightBtn = MouseButtonInteraction.Button.RIGHT;
    
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem1");
    
    simulateInteraction(element1, new MouseButtonDown(leftBtn));
    simulateInteraction(element1, new MouseButtonUp(leftBtn));
    simulateInteraction(element1, new MouseClick(leftBtn));

    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence {" +
       "  Interaction LeftMouseClick {}" +
       "}", getTaskTree().getTaskMap());
    
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element1, new DummyInteraction("bli", 1));
    simulateInteraction(element1, new MouseButtonDown(middleBtn));
    simulateInteraction(element1, new MouseButtonUp(middleBtn));
    simulateInteraction(element1, new MouseClick(middleBtn));
    simulateInteraction(element1, new DummyInteraction("blo", 1));
    simulateInteraction(element1, new DummyInteraction("blu", 1));

    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence {" +
       "  Interaction LeftMouseClick {}" +
       "  Interaction bla {}" +
       "  Interaction bli {}" +
       "  Interaction MiddleMouseClick {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "}", getTaskTree().getTaskMap());

    simulateInteraction(element2, new DummyInteraction("bla", 1));
    simulateInteraction(element2, new DummyInteraction("bli", 1));
    simulateInteraction(element2, new MouseButtonDown(rightBtn));
    simulateInteraction(element2, new MouseButtonUp(rightBtn));
    simulateInteraction(element2, new MouseClick(rightBtn));
    simulateInteraction(element2, new DummyInteraction("blo", 1));
    simulateInteraction(element2, new DummyInteraction("blu", 1));

    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction LeftMouseClick {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction MiddleMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction RightMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());

    simulateInteraction(element1, new MouseButtonDown(leftBtn));
    simulateInteraction(element1, new MouseButtonUp(leftBtn));
    simulateInteraction(element2, new MouseClick(leftBtn));

    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction LeftMouseClick {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction MiddleMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction RightMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction LeftMouseButtonDown {}" +
       "    Interaction LeftMouseButtonUp {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction LeftMouseClick {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());

    simulateInteraction(element1, new MouseButtonDown(middleBtn));
    simulateInteraction(element1, new MouseButtonUp(middleBtn));
    simulateInteraction(element1, new MouseClick(rightBtn));
    simulateInteraction(element2, new DummyInteraction("bla", 1));

    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction LeftMouseClick {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction MiddleMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction RightMouseClick {}" +
       "    Interaction blo {}" +
       "    Interaction blu {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction LeftMouseButtonDown {}" +
       "    Interaction LeftMouseButtonUp {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction LeftMouseClick {}" +
       "  }" +
       "  Sequence sequence5 {" +
       "    Sequence sequence6 {" +
       "      Interaction MiddleMouseButtonDown {}" +
       "      Interaction MiddleMouseButtonUp {}" +
       "    }" +
       "    Interaction RightMouseClick {}" +
       "  }" +
       "  Sequence sequence7 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());

  }
  
}
