//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTreeNodeFactoryImpl.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 21.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.tasktrees.treeifc.InteractionTask;
import de.ugoe.cs.quest.tasktrees.treeifc.Iteration;
import de.ugoe.cs.quest.tasktrees.treeifc.Selection;
import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeifc.TextInputInteractionTask;
import de.ugoe.cs.tasktree.guimodel.GUIElement;
import de.ugoe.cs.tasktree.userinteraction.Interaction;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class TaskTreeNodeFactoryImpl implements TaskTreeNodeFactory
{

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see TaskTreeNodeFactory#createNewInteractionTask(GUIElement, Interaction)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public InteractionTask createNewInteractionTask(GUIElement  guiElement,
                                                  Interaction interaction)
  {
    return new InteractionTaskImpl(guiElement, interaction);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSequence()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public Sequence createNewSequence()
  {
    return new SequenceImpl();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewTextInputInteractionTask()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public TextInputInteractionTask createNewTextInputInteractionTask(GUIElement guiElement)
  {
    return new TextInputInteractionTaskImpl(guiElement);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewIteration()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public Iteration createNewIteration()
  {
    return new IterationImpl();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSelection()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public Selection createNewSelection()
  {
    return new SelectionImpl();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createTaskTree(de.ugoe.cs.tasktree.treeifc.TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public TaskTree createTaskTree(TaskTreeNode root)
  {
    return new TaskTreeImpl(root);
  }

}
