//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TreeNode.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 06.11.2011 11:00:46 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.treeimpl;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;


//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------
public abstract class TaskTreeNodeImpl implements TaskTreeNode
{
  /** */
  private static int sTemporalId = 0;

  /** */
  private String mName;

  /** */
  private String mDescription;
  
  /** */
  private int mId;
  
  /** children */
  private List<TaskTreeNode> mChildren;

  //-----------------------------------------------------------------------------------------------
  /**
   */
  //-----------------------------------------------------------------------------------------------
  TaskTreeNodeImpl(String name)
  {
    mName = name;
    mId = getNewId();
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  private static synchronized int getNewId()
  {
    if (sTemporalId == Integer.MAX_VALUE)
    {
      sTemporalId = 0;
    }
    
    return sTemporalId++;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @return Returns the name.
   */
  //-----------------------------------------------------------------------------------------------
  public String getName()
  {
    return mName;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNode#getDescription()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public String getDescription()
  {
    return mDescription;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   */
  //-----------------------------------------------------------------------------------------------
  public synchronized List<TaskTreeNode> getChildren()
  {
    if ((mChildren == null) || (mChildren.size() == 0))
    {
      return new ArrayList<TaskTreeNode>();
    }
    
    return mChildren.subList(0, mChildren.size());
  }
  
  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized boolean equals(Object other)
  {
    if (!this.getClass().isInstance(other))
    {
      return false;
    }
    else
    {
      return equals((TaskTreeNodeImpl) other);
    }
  }
    
  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNode#equals(de.ugoe.cs.tasktree.treeifc.TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public boolean equals(TaskTreeNode other)
  {
    if (!this.getClass().isInstance(other))
    {
      return false;
    }
    else
    {
      return equals((TaskTreeNodeImpl) other);
    }
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  //-----------------------------------------------------------------------------------------------
  public synchronized boolean equals(TaskTreeNodeImpl other)
  {
    if (!this.getClass().isInstance(other))
    {
      return false;
    }
    
    if (other.hashCode() != hashCode())
    {
      return false;
    }
    
    if (mId != other.mId)
    {
      return false;
    }
    
    if (!mName.equals(other.mName))
    {
      return false;
    }
    
    synchronized (other)
    {
      if ((other.mChildren == null) && (mChildren == null))
      {
        return true;
      }
      
      if (((other.mChildren == null) && (mChildren != null)) ||
          ((other.mChildren != null) && (mChildren == null)))
      {
        return false;
      }
      
      if (other.mChildren.size() != mChildren.size())
      {
        return false;
      }
      
      for (int i = 0; i < mChildren.size(); i++)
      {
        if (!mChildren.get(i).equals(other.mChildren.get(i)))
        {
          return false;
        }
      }
    }

    return true;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized int hashCode()
  {
    return getClass().getSimpleName().hashCode();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized String toString()
  {
    if (mChildren == null)
    {
      return mName + "(" + mId + ")";
    }
    else
    {
      return mName + "(" + mId + ", " + mChildren.size() + " children)";
    }
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param i
   * @return 
   */
  //-----------------------------------------------------------------------------------------------
  void setDescription(String description)
  {
    mDescription = description;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   */
  //-----------------------------------------------------------------------------------------------
  synchronized void addChild(TaskTreeNode child)
  {
    if (mChildren == null)
    {
      mChildren = new ArrayList<TaskTreeNode>();
    }
    
    mChildren.add(child);
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   */
  //-----------------------------------------------------------------------------------------------
  synchronized void addChild(int index, TaskTreeNode child)
  {
    if (mChildren == null)
    {
      mChildren = new ArrayList<TaskTreeNode>();
    }
    
    mChildren.add(index, child);
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param i
   * @return 
   */
  //-----------------------------------------------------------------------------------------------
  synchronized TaskTreeNode removeChild(int index)
  {
    return mChildren.remove(index);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#clone()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public abstract TaskTreeNode clone();

}
