package de.ugoe.cs.quest.assertions;

import java.security.InvalidParameterException;

import de.ugoe.cs.quest.eventcore.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the replay for a textEquals assertion.
 * </p>
 * 
 * @author Jeffrey Hall, Steffen Herbold
 * @version 2.0
 */
public class TextEqualsReplay implements IReplayable {

	/**
	 * <p>
	 * Reference value which is compared to the targets text.
	 * </p>
	 */
	protected final String expectedValue;

	/**
	 * <p>
	 * Target to which the text is compared.
	 * </p>
	 */
	protected final String target;

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * Constructor. Creates a new TextEqualsReplay.
	 * 
	 * @param expectedValue
	 *            expected string value
	 * @param target
	 *            string description of the target whose string value is
	 *            compared to the expected value
	 * @throws InvalidParameterException
	 *             thrown if target is null
	 */
	public TextEqualsReplay(String expectedValue, String target) {
		if (target == null) {
			throw new InvalidParameterException("target must not be null");
		}
		this.expectedValue = expectedValue;
		this.target = target;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.eventcore.IReplayable#getReplay()
	 */
	@Override
	public String getReplay() {

		String expectedValueTmp = StringTools.xmlEntityReplacement(expectedValue);

		StringBuilder currentMsgStr = new StringBuilder(400);
		currentMsgStr.append(" <textEquals expectedValue=\"" + expectedValueTmp
				+ "\">");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("<target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append(target);
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</textEquals>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.eventcore.IReplayable#getTarget()
	 */
	@Override
	public String getTarget() {
		return target;
	}

}
