package de.ugoe.cs.quest.coverage;

import java.util.ArrayList;
import java.util.Collection;
import de.ugoe.cs.quest.coverage.CoverageCalculatorObserved;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.usageprofiles.MockTrieBasedModel;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.junit.*;

import static org.junit.Assert.*;

/**
 * The class <code>CoverageCalculatorObservedTest</code> contains tests for the
 * class <code>{@link CoverageCalculatorObserved}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CoverageCalculatorObservedTest {
	
	Collection<List<? extends Event<?>>> sequencesObserved;
	
	Set<List<? extends Event<?>>> sequencesCovered;
	Set<List<? extends Event<?>>> sequencesCovered2;
	Set<List<? extends Event<?>>> sequencesNewPossible;
	
	MockTrieBasedModel mockProcess;
	
	@Test
	public void testCoverageCalculatorObserved_1() throws Exception {
		int length = 2;

		CoverageCalculatorObserved result = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		assertNotNull(result);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testCoverageCalculatorObserved_2() throws Exception {
		int length = 2;

		new CoverageCalculatorObserved(null,sequencesCovered, length);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testCoverageCalculatorObserved_3() throws Exception {
		int length = 2;

		new CoverageCalculatorObserved(sequencesObserved, null, length);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testCoverageCalculatorObserved_4() throws Exception {
		int length = 0;

		new CoverageCalculatorObserved(sequencesObserved, sequencesCovered, length);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testCoverageCalculatorObserved_5() throws Exception {
		int length = -1;

		new CoverageCalculatorObserved(sequencesObserved, sequencesCovered, length);
	}
	
	@Test
	public void testCoverageObserved_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		double result = fixture.getCoverageObserved();
		
		assertEquals(3.0/6.0, result, 0.0001);
	}
	
	@Test
	public void testCoverageObserved_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered2, length);
		
		double result = fixture.getCoverageObserved();
		
		assertEquals(2.0/6.0, result, 0.0001);
	}
	
	@Test
	public void testCoverageObservedWeigth_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		double result = fixture.getCoverageObservedWeigth(mockProcess);
		
		assertEquals(6.0, result, 0.0001);
	}
	
	@Test
	public void testCoverageObservedWeigth_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered2, length);
		
		double result = fixture.getCoverageObservedWeigth(mockProcess);
		
		assertEquals(4.0, result, 0.0001);
	}
	
	@Test
	public void testGetNewPercentage_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		double result = fixture.getNewPercentage();
		
		assertEquals(1.0/4.0, result, 0.0001);
	}
	
	@Test
	public void testGetNewPercentage_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered2, length);
		
		double result = fixture.getNewPercentage();
		
		assertEquals(0.0, result, 0.0001);
	}
	
	@Test
	public void testCoveragePossibleNew_1() throws Exception {
		int length = 3;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesNewPossible, length);
		
		double result = fixture.getCoveragePossibleNew(mockProcess);
		
		assertEquals(1.0/11.0, result, 0.0001);
	}
	
	@Test
	public void testCoveragePossibleNew_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		double result = fixture.getCoveragePossibleNew(mockProcess);
		
		assertEquals(0.0, result, 0.0001);
	}
	
	@Test(expected = java.security.InvalidParameterException.class ) 
	public void testCoveragePossibleNew_3() throws Exception {
		int length = 3;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		fixture.getCoveragePossibleNew(null);
	}
	
	@Test
	public void testCoveragePossibleNewWeight_1() throws Exception {
		int length = 3;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesNewPossible, length);
		
		double result = fixture.getCoveragePossibleNewWeight(mockProcess);
		
		assertEquals(2.0, result, 0.0001);
	}
	
	@Test
	public void testCoveragePossibleNewWeight_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		double result = fixture.getCoveragePossibleNewWeight(mockProcess);
		
		assertEquals(0.0, result, 0.0001);
	}
	
	@Test(expected = java.security.InvalidParameterException.class ) 
	public void testCoveragePossibleNewWeight_3() throws Exception {
		int length = 3;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		fixture.getCoveragePossibleNewWeight(null);
	}	
	
	
	@Test
	public void testGetNumObserved_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		int result = fixture.getNumObserved();
		
		assertEquals(6, result);
	}
	
	@Test
	public void testGetNumCovered_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		int result = fixture.getNumCovered();
		
		assertEquals(4, result);
	}
	
	@Test
	public void testGetNumCovered_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered2, length);
		
		int result = fixture.getNumCovered();
		
		assertEquals(2, result);
	}
	
	@Test
	public void testGetNumNew_1() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered, length);
		
		int result = fixture.getNumNew();
		
		assertEquals(1, result);
	}
	
	@Test
	public void testGetNumNew_2() throws Exception {
		int length = 2;
		CoverageCalculatorObserved fixture = new CoverageCalculatorObserved(
				sequencesObserved, sequencesCovered2, length);
		
		int result = fixture.getNumNew();
		
		assertEquals(0, result);
	}
	
	@Before
	public void setUp() throws Exception {
		sequencesObserved = new LinkedList<List<? extends Event<?>>>();
		List<Event<?>> sequence1 = new ArrayList<Event<?>>();
		sequence1.add(new Event<String>("a"));
		sequence1.add(new Event<String>("b"));
		sequence1.add(new Event<String>("r"));
		sequence1.add(new Event<String>("a"));
		List<Event<?>> sequence2 = new ArrayList<Event<?>>();
		sequence2.add(new Event<String>("c"));
		sequence2.add(new Event<String>("a"));
		sequence2.add(new Event<String>("d"));
		sequence2.add(new Event<String>("a"));
		sequence2.add(new Event<String>("b"));
		sequence2.add(new Event<String>("r"));
		sequence2.add(new Event<String>("a"));
		sequencesObserved.add(sequence1);
		sequencesObserved.add(sequence2);

		sequencesCovered = new LinkedHashSet<List<? extends Event<?>>>();
		List<Event<?>> tmpList = new ArrayList<Event<?>>();
		tmpList.add(new Event<String>("a"));
		tmpList.add(new Event<String>("b"));
		tmpList.add(new Event<String>("r"));
		sequencesCovered.add(tmpList);
		tmpList = new ArrayList<Event<?>>();
		tmpList.add(new Event<String>("b"));
		tmpList.add(new Event<String>("r"));
		tmpList.add(new Event<String>("a"));
		tmpList.add(new Event<String>("e"));
		sequencesCovered.add(tmpList);

		sequencesCovered2 = new LinkedHashSet<List<? extends Event<?>>>();
		tmpList = new ArrayList<Event<?>>();
		tmpList.add(new Event<String>("a"));
		tmpList.add(new Event<String>("b"));
		tmpList.add(new Event<String>("r"));
		sequencesCovered2.add(tmpList);
		
		sequencesNewPossible = new LinkedHashSet<List<? extends Event<?>>>();
		tmpList = new ArrayList<Event<?>>();
		tmpList.add(new Event<String>("r"));
		tmpList.add(new Event<String>("a"));
		tmpList.add(new Event<String>("b"));
		sequencesNewPossible.add(tmpList);
		
		int markovOrder = 2;
		mockProcess = new MockTrieBasedModel(markovOrder, new Random());
		mockProcess.train(sequencesObserved);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore()
				.run(CoverageCalculatorObservedTest.class);
	}

}
