package de.ugoe.cs.quest.assertions;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.IReplayable;
import de.ugoe.cs.quest.eventcore.ReplayableEvent;

/**
 * <p>
 * Subclass of {@link ReplayableEvent} for assertions
 * </p>
 * 
 * @author Jeffrey Hall
 * @version 1.0
 * 
 * @param <T>
 *            Allows only types that extend {@link IReplayable} and is used to
 *            define the type of the assertion.
 * 
 */
public class AssertEvent<T extends IReplayable> extends ReplayableEvent<T> {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * Constructor. Creates a new event with the given type.
	 * <p>
	 * 
	 * @param type
	 *            type of the event
	 * @see Event#Event(String)
	 */
	public AssertEvent(String type) {
		super(type);
	}
}
