//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: DefaultIterationDetectionRuleTest.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 28.04.2012 $
// Project   : TaskTreeTemporalRelationship
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.TextField;
import de.ugoe.cs.quest.eventcore.userinteraction.KeyPressed;
import de.ugoe.cs.quest.eventcore.userinteraction.KeyReleased;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;
import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class DefaultTextInputReductionRuleTest extends AbstractTemporalRelationshipTC
{

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testSimpleTextEntry()
  {
    GUIElement element1 = new DummyTextField("elem1");
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_A));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_A));
    new TaskTreeChecker(true).assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput a {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_B));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_B));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput ab {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput abC {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_C {}" +
       "    Interaction KeyReleased LETTER_C {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_D));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_D));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_E));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_E));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_F));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_F));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput abCDEF {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_C {}" +
       "    Interaction KeyReleased LETTER_C {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_D {}" +
       "    Interaction KeyReleased LETTER_D {}" +
       "    Interaction KeyPressed LETTER_E {}" +
       "    Interaction KeyReleased LETTER_E {}" +
       "    Interaction KeyPressed LETTER_F {}" +
       "    Interaction KeyReleased LETTER_F {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    


    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_G));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_G));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput abCDEFg {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_C {}" +
       "    Interaction KeyReleased LETTER_C {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_D {}" +
       "    Interaction KeyReleased LETTER_D {}" +
       "    Interaction KeyPressed LETTER_E {}" +
       "    Interaction KeyReleased LETTER_E {}" +
       "    Interaction KeyPressed LETTER_F {}" +
       "    Interaction KeyReleased LETTER_F {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed SHIFT {}" +
       "    Interaction KeyPressed LETTER_G {}" +
       "    Interaction KeyReleased LETTER_G {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "    Interaction KeyReleased SHIFT {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testTextEntryOnDifferentGuiElements()
  {
    GUIElement element1 = new DummyTextField("elem1");
    GUIElement element2 = new DummyTextField("elem2");
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_A));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_A));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput a {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element2, new KeyPressed(VirtualKey.LETTER_B));
    simulateInteraction(element2, new KeyReleased(VirtualKey.LETTER_B));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    TextInputInteraction TextInput a {" +
       "      Interaction KeyPressed LETTER_A {}" +
       "      Interaction KeyReleased LETTER_A {}" +
       "    }" +
       "  }" +
       "  Sequence sequence2 {" +
       "    TextInputInteraction TextInput b {" +
       "      Interaction KeyPressed LETTER_B {}" +
       "      Interaction KeyReleased LETTER_B {}" +
       "    }" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    TextInputInteraction TextInput a {" +
       "      Interaction KeyPressed LETTER_A {}" +
       "      Interaction KeyReleased LETTER_A {}" +
       "    }" +
       "  }" +
       "  Sequence sequence2 {" +
       "    TextInputInteraction TextInput b {" +
       "      Interaction KeyPressed LETTER_B {}" +
       "      Interaction KeyReleased LETTER_B {}" +
       "    }" +
       "  }" +
       "  Sequence sequence3 {" +
       "    TextInputInteraction TextInput C {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_C {}" +
       "      Interaction KeyReleased LETTER_C {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element2, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element2, new KeyPressed(VirtualKey.LETTER_D));
    simulateInteraction(element2, new KeyReleased(VirtualKey.LETTER_D));
    simulateInteraction(element2, new KeyPressed(VirtualKey.LETTER_E));
    simulateInteraction(element2, new KeyReleased(VirtualKey.LETTER_E));
    simulateInteraction(element2, new KeyPressed(VirtualKey.LETTER_F));
    simulateInteraction(element2, new KeyReleased(VirtualKey.LETTER_F));
    simulateInteraction(element2, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    TextInputInteraction TextInput a {" +
       "      Interaction KeyPressed LETTER_A {}" +
       "      Interaction KeyReleased LETTER_A {}" +
       "    }" +
       "  }" +
       "  Sequence sequence2 {" +
       "    TextInputInteraction TextInput b {" +
       "      Interaction KeyPressed LETTER_B {}" +
       "      Interaction KeyReleased LETTER_B {}" +
       "    }" +
       "  }" +
       "  Sequence sequence3 {" +
       "    TextInputInteraction TextInput C {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_C {}" +
       "      Interaction KeyReleased LETTER_C {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "  Sequence sequence4 {" +
       "    TextInputInteraction TextInput DEF {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_D {}" +
       "      Interaction KeyReleased LETTER_D {}" +
       "      Interaction KeyPressed LETTER_E {}" +
       "      Interaction KeyReleased LETTER_E {}" +
       "      Interaction KeyPressed LETTER_F {}" +
       "      Interaction KeyReleased LETTER_F {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "}", getTaskTree().getTaskMap());    


    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_G));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_G));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    simulateInteraction(element1, new KeyReleased(VirtualKey.SHIFT));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    TextInputInteraction TextInput a {" +
       "      Interaction KeyPressed LETTER_A {}" +
       "      Interaction KeyReleased LETTER_A {}" +
       "    }" +
       "  }" +
       "  Sequence sequence2 {" +
       "    TextInputInteraction TextInput b {" +
       "      Interaction KeyPressed LETTER_B {}" +
       "      Interaction KeyReleased LETTER_B {}" +
       "    }" +
       "  }" +
       "  Sequence sequence3 {" +
       "    TextInputInteraction TextInput C {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_C {}" +
       "      Interaction KeyReleased LETTER_C {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "  Sequence sequence4 {" +
       "    TextInputInteraction TextInput DEF {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_D {}" +
       "      Interaction KeyReleased LETTER_D {}" +
       "      Interaction KeyPressed LETTER_E {}" +
       "      Interaction KeyReleased LETTER_E {}" +
       "      Interaction KeyPressed LETTER_F {}" +
       "      Interaction KeyReleased LETTER_F {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "  Sequence sequence5 {" +
       "    TextInputInteraction TextInput g {" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed SHIFT {}" +
       "      Interaction KeyPressed LETTER_G {}" +
       "      Interaction KeyReleased LETTER_G {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "      Interaction KeyReleased SHIFT {}" +
       "    }" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testUsageOfBackspace()
  {
    GUIElement element1 = new DummyTextField("elem1");
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_A));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_A));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_B));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_B));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_C));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_D));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_D));
    simulateInteraction(element1, new KeyPressed(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyReleased(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_E));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_E));
    simulateInteraction(element1, new KeyPressed(VirtualKey.LETTER_F));
    simulateInteraction(element1, new KeyReleased(VirtualKey.LETTER_F));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput abcef {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "    Interaction KeyPressed LETTER_C {}" +
       "    Interaction KeyReleased LETTER_C {}" +
       "    Interaction KeyPressed LETTER_D {}" +
       "    Interaction KeyReleased LETTER_D {}" +
       "    Interaction KeyPressed BACK_SPACE {}" +
       "    Interaction KeyReleased BACK_SPACE {}" +
       "    Interaction KeyPressed LETTER_E {}" +
       "    Interaction KeyReleased LETTER_E {}" +
       "    Interaction KeyPressed LETTER_F {}" +
       "    Interaction KeyReleased LETTER_F {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

    simulateInteraction(element1, new KeyPressed(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyReleased(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyPressed(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyReleased(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyPressed(VirtualKey.BACK_SPACE));
    simulateInteraction(element1, new KeyReleased(VirtualKey.BACK_SPACE));
    new TaskTreeChecker().assertTaskMap
      ("Sequence sequence0 {" +
       "  TextInputInteraction TextInput ab {" +
       "    Interaction KeyPressed LETTER_A {}" +
       "    Interaction KeyReleased LETTER_A {}" +
       "    Interaction KeyPressed LETTER_B {}" +
       "    Interaction KeyReleased LETTER_B {}" +
       "    Interaction KeyPressed LETTER_C {}" +
       "    Interaction KeyReleased LETTER_C {}" +
       "    Interaction KeyPressed LETTER_D {}" +
       "    Interaction KeyReleased LETTER_D {}" +
       "    Interaction KeyPressed BACK_SPACE {}" +
       "    Interaction KeyReleased BACK_SPACE {}" +
       "    Interaction KeyPressed LETTER_E {}" +
       "    Interaction KeyReleased LETTER_E {}" +
       "    Interaction KeyPressed LETTER_F {}" +
       "    Interaction KeyReleased LETTER_F {}" +
       "    Interaction KeyPressed BACK_SPACE {}" +
       "    Interaction KeyReleased BACK_SPACE {}" +
       "    Interaction KeyPressed BACK_SPACE {}" +
       "    Interaction KeyReleased BACK_SPACE {}" +
       "    Interaction KeyPressed BACK_SPACE {}" +
       "    Interaction KeyReleased BACK_SPACE {}" +
       "  }" +
       "}", getTaskTree().getTaskMap());    

  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  private static class DummyTextField extends DummyGUIElement implements TextField
  {

    //---------------------------------------------------------------------------------------------
    /**
     * TODO: comment
     *
     * @param name
     */
    //---------------------------------------------------------------------------------------------
    public DummyTextField(String name)
    {
      super(name);
    }

  }

}
