//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: UsabilityDefect.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 16.07.2012 $
// Project   : UsabilityEvaluationManager
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.usability;

import java.util.Map;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
//-------------------------------------------------------------------------------------------------
public class UsabilityDefect
{

  /** */
  private UsabilityDefectSeverity mSeverity;
  
  /** */
  private UsabilityDefectDescription mDescription;

  /** */
  private Map<String, String> mDescriptionParameters;

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param medium
   * @param highTextInputRatio
   */
  //-----------------------------------------------------------------------------------------------
  public UsabilityDefect(UsabilityDefectSeverity    severity,
                         UsabilityDefectDescription description)
  {
    this(severity, description, null);
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param medium
   * @param highTextInputRatio
   */
  //-----------------------------------------------------------------------------------------------
  public UsabilityDefect(UsabilityDefectSeverity    severity,
                         UsabilityDefectDescription description,
                         Map<String, String>        parameters)
  {
    mSeverity = severity;
    mDescription = description;
    mDescriptionParameters = parameters;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public UsabilityDefectSeverity getSeverity()
  {
    return mSeverity;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @param severity the severity to set
   */
  //-----------------------------------------------------------------------------------------------
  public void setSeverity(UsabilityDefectSeverity severity)
  {
    mSeverity = severity;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @param description the description to set
   */
  //-----------------------------------------------------------------------------------------------
  public void setDescription(UsabilityDefectDescription description)
  {
    mDescription = description;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * 
   */
  //-----------------------------------------------------------------------------------------------
  public String getParameterizedDescription()
  {
    return mDescription.toString(mDescriptionParameters);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public boolean equals(Object obj)
  {
    if (obj instanceof UsabilityDefect)
    {
      return
        (mSeverity == ((UsabilityDefect) obj).mSeverity) &&
        (mDescription == ((UsabilityDefect) obj).mDescription);
    }
    else
    {
      return false;
    }
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public String toString()
  {
    return "UsabilityDefect(" + mSeverity.name() + ", " + mDescription.name() + ")";
  }

}
