//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: UsabilityEvaluationManager.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 16.07.2012 $
// Project   : UsabilityEvaluationManager
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.usability;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import de.ugoe.cs.quest.tasktrees.treeifc.TaskTree;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
//-------------------------------------------------------------------------------------------------
public class UsabilityEvaluationManager
{
  /** */
  private static Logger LOG = Logger.getLogger(UsabilityEvaluationManager.class.getName());

  /** */
  private List<UsabilityEvaluationRule> mRules = new ArrayList<UsabilityEvaluationRule>();
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  public UsabilityEvaluationManager()
  {
    super();
    init();
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  private void init()
  {
    mRules.add(new TextInputStatisticsRule());
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param taskTree
   */
  //-----------------------------------------------------------------------------------------------
  public UsabilityEvaluationResult evaluateUsability(TaskTree taskTree)
  {
    LOG.info("evaluating usability of task tree " + taskTree);
    
    List<UsabilityEvaluationResult> results = new ArrayList<UsabilityEvaluationResult>();
    
    for (UsabilityEvaluationRule rule : mRules)
    {
      LOG.info("applying rule " + rule.getClass().getSimpleName());
      UsabilityEvaluationResult result = rule.evaluate(taskTree);
      results.add(result);
      LOG.info("the rule found " + result.getAllDefects().size() + " usability defects, of " +
                "which " + result.getSevereDefects().size() + " are severe.");
    }
    
    UsabilityEvaluationResult result = mergeResults(results);
    LOG.info("the evaluation result contains " + result.getAllDefects().size() + " defects, of " +
             "which " + result.getSevereDefects().size() + " are severe.");
    return result;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param results
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  private UsabilityEvaluationResult mergeResults(List<UsabilityEvaluationResult> results)
  {
    UsabilityEvaluationResult result = new UsabilityEvaluationResult();
    
    for (UsabilityEvaluationResult ruleResult : results)
    {
      for (UsabilityDefect defect : ruleResult.getAllDefects())
      {
        result.addDefect(defect);
      }
    }
    
    return result;
  }
  
}
