//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: KeyStroke.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 11.07.2012 $
// Project   : KeyboardMaps
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.tasktree.keyboardmaps;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 11.07.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class KeyStroke
{

  /** */
  private String mKeyStrokeName;

  /** */
  private VirtualKey mVirtualKey;

  /** */
  private boolean mNumlock;

  /** */
  private boolean mLocalstate;

  /** */
  private boolean mShift;

  /** */
  private boolean mAltgr;

  /** */
  private boolean mInhibit;

  /** */
  private char mCharacter;

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param keyStrokeName
   * @param mapKeyIdToVirtualKey
   * @param numlock
   * @param localstate
   * @param b
   * @param altgr
   * @param inhibit
   */
  //-----------------------------------------------------------------------------------------------
  public KeyStroke(String     keyStrokeName,
                   VirtualKey virtualKey,
                   boolean    numlock,
                   boolean    localstate,
                   boolean    shift,
                   boolean    altgr,
                   boolean    inhibit,
                   char       character)
  {
    mKeyStrokeName = keyStrokeName;
    mVirtualKey = virtualKey;
    mNumlock = numlock;
    mLocalstate = localstate;
    mShift = shift;
    mAltgr = altgr;
    mInhibit = inhibit;
    mCharacter = character;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @return the keyStrokeName
   */
  //-----------------------------------------------------------------------------------------------
  public String getKeyStrokeName()
  {
    return mKeyStrokeName;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public VirtualKey getVirtualKey()
  {
    return mVirtualKey;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public char getCharacter()
  {
    return mCharacter;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public boolean getInhibit()
  {
    return mInhibit;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public boolean getAltgr()
  {
    return mAltgr;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public boolean getShift()
  {
    return mShift;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public boolean getLocalstate()
  {
    return mLocalstate;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public boolean getNumlock()
  {
    return mNumlock;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public String toString()
  {
    StringBuffer toString = new StringBuffer();
    toString.append("KeyStroke(");
    toString.append(mKeyStrokeName);
    toString.append(", ");
    toString.append(mVirtualKey);
    
    if (mCharacter != Character.UNASSIGNED)
    {
      toString.append(", \'");
      toString.append(mCharacter);
      toString.append("\'");
    }
    
    if (mShift)
    {
      toString.append(", shift");
    }
    
    if (mAltgr)
    {
      toString.append(", altgr");
    }
    
    if (mNumlock)
    {
      toString.append(", numlock");
    }
    
    if (mLocalstate)
    {
      toString.append(", localstate");
    }
    
    if (mInhibit)
    {
      toString.append(", inhibit");
    }
    
    toString.append(")");

    return toString.toString();
  }

}
