package de.ugoe.cs.quest.plugin.guitar.eventcore;

import de.ugoe.cs.quest.eventcore.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayable} used to generate test cases for the GUITAR suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class EFGReplayable implements IReplayable {

	/**
	 * <p>
	 * EventId in the EFG and GUI files.
	 * </p>
	 */
	String eventId;

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * Constructor. Creates a new {@link EFGReplayable}.
	 * </p>
	 * 
	 * @param eventId
	 */
	public EFGReplayable(String eventId) {
		this.eventId = eventId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.eventcore.IReplayable#getReplay()
	 */
	@Override
	public String getReplay() {
		StringBuilder replay = new StringBuilder();
		replay.append("<Step>" + StringTools.ENDLINE);
		replay.append("<EventId>" + eventId + "</EventId>" + StringTools.ENDLINE);
		replay.append("<ReachingStep>false</ReachingStep>" + StringTools.ENDLINE);
		replay.append("</Step>" + StringTools.ENDLINE);
		return replay.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.eventcore.IReplayable#getTarget()
	 */
	@Override
	public String getTarget() {
		return null; // target indirectly included in replay through the eventId
	}

}
