/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import junitx.framework.Assert;

public class ComparableAssert {
    private ComparableAssert() {
    }

    public static void assertLesser(String message, Comparable limit, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)limit);
        Assert.assertNotNull((String)message, (Object)actual);
        if (limit.compareTo(actual) <= 0) {
            ComparableAssert.failLesser(message, limit, actual);
        }
    }

    public static void assertLesser(Comparable limit, Comparable actual) {
        ComparableAssert.assertLesser(null, limit, actual);
    }

    public static void assertNotLesser(String message, Comparable limit, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)limit);
        Assert.assertNotNull((String)message, (Object)actual);
        if (limit.compareTo(actual) > 0) {
            ComparableAssert.failNotLesser(message, limit, actual);
        }
    }

    public static void assertNotLesser(Comparable limit, Comparable actual) {
        ComparableAssert.assertNotLesser(null, limit, actual);
    }

    public static void assertEquals(String message, Comparable expected, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)expected);
        Assert.assertNotNull((String)message, (Object)actual);
        if (expected.compareTo(actual) != 0) {
            ComparableAssert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(Comparable expected, Comparable actual) {
        ComparableAssert.assertEquals(null, expected, actual);
    }

    public static void assertNotEquals(String message, Comparable expected, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)expected);
        Assert.assertNotNull((String)message, (Object)actual);
        if (expected.compareTo(actual) == 0) {
            ComparableAssert.failEquals(message, expected);
        }
    }

    public static void assertNotEquals(Comparable expected, Comparable actual) {
        ComparableAssert.assertNotEquals(null, expected, actual);
    }

    public static void assertGreater(String message, Comparable limit, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)limit);
        Assert.assertNotNull((String)message, (Object)actual);
        if (limit.compareTo(actual) >= 0) {
            ComparableAssert.failGreater(message, limit, actual);
        }
    }

    public static void assertGreater(Comparable limit, Comparable actual) {
        ComparableAssert.assertGreater(null, limit, actual);
    }

    public static void assertNotGreater(String message, Comparable limit, Comparable actual) {
        Assert.assertNotNull((String)message, (Object)limit);
        Assert.assertNotNull((String)message, (Object)actual);
        if (limit.compareTo(actual) < 0) {
            ComparableAssert.failNotGreater(message, limit, actual);
        }
    }

    public static void assertNotGreater(Comparable limit, Comparable actual) {
        ComparableAssert.assertNotGreater(null, limit, actual);
    }

    private static void failGreater(String message, Object limit, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected greater than:<" + limit + "> but was:<" + actual + ">"));
    }

    private static void failNotGreater(String message, Object limit, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected not greater than:<" + limit + "> but was:<" + actual + ">"));
    }

    private static void failLesser(String message, Object limit, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected lesser than:<" + limit + "> but was:<" + actual + ">"));
    }

    private static void failNotLesser(String message, Object limit, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected not lesser than:<" + limit + "> but was:<" + actual + ">"));
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected equals to:<" + expected + "> but was:<" + actual + ">"));
    }

    private static void failEquals(String message, Object expected) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected not equals to:<" + expected + ">"));
    }
}

