//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: InteractionTask.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 06.11.2011 10:57:52 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.userinteraction.Interaction;
import de.ugoe.cs.quest.tasktrees.treeifc.InteractionTask;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------
public class InteractionTaskImpl extends TaskTreeNodeImpl implements InteractionTask
{
  /** */
  private GUIElement mGUIElement;
  
  /** */
  private Interaction mInteraction;

  //-----------------------------------------------------------------------------------------------
  /**
   * @param guiElement
   * @param interaction
   */
  //-----------------------------------------------------------------------------------------------
  InteractionTaskImpl(GUIElement guiElement, Interaction interaction)
  {
    super(interaction.getName() + "(" + guiElement + ")");
    super.setDescription(interaction + " on " + guiElement);
    mGUIElement = guiElement;
    mInteraction = interaction;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * @return Returns the interaction.
   */
  //-----------------------------------------------------------------------------------------------
  public Interaction getInteraction()
  {
    return mInteraction;
  }

  
  //-----------------------------------------------------------------------------------------------
  /**
   * @return Returns the GUIElement.
   */
  //-----------------------------------------------------------------------------------------------
  public GUIElement getGUIElement()
  {
    return mGUIElement;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.harms.ctte.Task#equals(de.harms.ctte.Task)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public boolean equals(TaskTreeNode task)
  {
    if (!(task instanceof InteractionTask))
    {
      return false;
    }
    
    GUIElement otherInteractionElem = ((InteractionTask) task).getGUIElement();
    Interaction otherInteraction = ((InteractionTask) task).getInteraction();
    
    if ((((mGUIElement == null) && (otherInteractionElem == null)) ||
         ((mGUIElement != null) && (mGUIElement.equals(otherInteractionElem)))) &&
        (((mInteraction == null) && (otherInteraction == null)) ||
         ((mInteraction != null) && (mInteraction.equals(otherInteraction)))))
    {
      return true;
    }
    
    return false;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.harms.tasktrees.TreeNode#clone()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public InteractionTaskImpl clone()
  {
    // GUI element and interaction are unchangeable and do not need to be cloned
    return (InteractionTaskImpl) super.clone();
  }

}
