//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: NodeInfo.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 05.11.2011 19:24:14 $
// Project   : TestTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.treeimpl;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.quest.tasktrees.treeifc.NodeInfo;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;


//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------
public class NodeInfoImpl implements NodeInfo
{
  /** */
  private TaskTreeNode mTask;
  
  /** */
  private long mLastUpdate;

  /** */
  private List<TaskTreeNode> mParentNodes = new ArrayList<TaskTreeNode>();

  //-----------------------------------------------------------------------------------------------
  /**
   * @param node 
   */
  //-----------------------------------------------------------------------------------------------
  NodeInfoImpl(TaskTreeNode task)
  {
    mTask = task;
    mLastUpdate = System.currentTimeMillis();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.NodeInfo#getTask()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public TaskTreeNode getTask()
  {
    return mTask;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getNoOfOccurencesInTree()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public int getNoOfOccurencesInTree()
  {
    return mParentNodes.size();
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getLastUpdate()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public long getLastUpdate()
  {
    return mLastUpdate;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  void addParent(TaskTreeNode parent)
  {
    mParentNodes.add(parent);
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  void removeParent(TaskTreeNode parent)
  {
    mParentNodes.remove(parent);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public synchronized String toString()
  {
    return "NodeInfo(" + mTask + ", " + mParentNodes.size() + " parents)";
  }
  
}
