//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTreeManagerTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 08.11.2011 21:32:36 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.manager;

import java.util.logging.Logger;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.userinteraction.Interaction;
import de.ugoe.cs.quest.eventcore.userinteraction.InteractionEvent;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.SimpleLogFormatter;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------

public class TaskTreeManagerTest
{
  /** */
  TaskTreeManager mManager;
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Before
  public void setUp()
  {
    Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());
    
    mManager = new TaskTreeManager();
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @After
  public void tearDown()
  {
    mManager = null;
    ComponentManager.clearInstance();
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testOneInteractionOnOneElement()
  {
    simulateInteraction(new DummyGUIElement("elem1"), new DummyInteraction("bla", 1));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence {" +
       "  Interaction bla {}" +
       "}", mManager.getTaskTree());
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testManyInteractionsOnOneElement()
  {
    GUIElement element = new DummyGUIElement("elem1");
    simulateInteraction(element, new DummyInteraction("bla", 1));
    simulateInteraction(element, new DummyInteraction("bli", 1));
    simulateInteraction(element, new DummyInteraction("blo", 1));
    simulateInteraction(element, new DummyInteraction("blu", 1));
    simulateInteraction(element, new DummyInteraction("bla", 1));

    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence {" +
       "  Interaction bla {}" +
       "  Interaction bli {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "  Interaction bla {}" +
       "}", mManager.getTaskTree());
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testOneInteractionOnManyElements()
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement element4 = new DummyGUIElement("elem4");
    GUIElement element5 = new DummyGUIElement("elem5");
    GUIElement element6 = new DummyGUIElement("elem6");
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element2, new DummyInteraction("bli", 1));
    simulateInteraction(element3, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element5, new DummyInteraction("blo", 1));
    simulateInteraction(element6, new DummyInteraction("bla", 1));
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bli {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction bli {}" +
       "  }" +
       "  Sequence sequence5 {" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", mManager.getTaskTree());
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testManyInteractionsOnManyElements()
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement element4 = new DummyGUIElement("elem4");
    GUIElement element5 = new DummyGUIElement("elem5");
    GUIElement element6 = new DummyGUIElement("elem6");
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element1, new DummyInteraction("bli", 1));
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element2, new DummyInteraction("bli", 1));
    simulateInteraction(element2, new DummyInteraction("blo", 1));
    simulateInteraction(element3, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element4, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element4, new DummyInteraction("blo", 1));
    simulateInteraction(element5, new DummyInteraction("bla", 1));
    simulateInteraction(element6, new DummyInteraction("bli", 1));
    simulateInteraction(element6, new DummyInteraction("bla", 1));
    simulateInteraction(element6, new DummyInteraction("bli", 1));
    simulateInteraction(element6, new DummyInteraction("blo", 1));

    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence5 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "}", mManager.getTaskTree());
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testInteractionIterationDetection() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    Interaction interaction1 = new DummyInteraction("bla", 1);
    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Interaction bla {}" +
       "}", mManager.getTaskTree());    

    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", mManager.getTaskTree());    

    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", mManager.getTaskTree());    

    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", mManager.getTaskTree());    
    
    // now test with preceding and trailing other interactions
    Interaction interaction2 = new DummyInteraction("bli", 1);
    Interaction interaction3 = new DummyInteraction("blup", 1);

    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
    }
    simulateInteraction(element1, interaction3);
    simulateInteraction(element1, interaction2);
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "  Iteration iteration2 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction blup {}" +
       "  Interaction bli {}" +
       "}", mManager.getTaskTree());    
  
    // now test with iterations of iterations

    for (int i = 0; i < 10; i++)
    {
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction2);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction3);
      }
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Iteration iteration0 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction blup {}" +
       "  Interaction bli {}" +
       "  Iteration iteration2 {" +
       "    Sequence sequence1 {" +
       "      Iteration iteration3 {" +
       "        Interaction bla {}" +
       "      }" +
       "      Iteration iteration4 {" +
       "        Interaction bli {}" +
       "      }" +
       "      Iteration iteration5 {" +
       "        Interaction blup {}" +
       "      }" +
       "    }" +
       "  }" +
       "}", mManager.getTaskTree());    
  
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testSequenceIterationDetection() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    Interaction interaction1 = new DummyInteraction("bla", 1);
    Interaction interaction2 = new DummyInteraction("bli", 1);
    Interaction interaction3 = new DummyInteraction("blup", 1);
    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Interaction bla {}" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "}", mManager.getTaskTree());    

    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", mManager.getTaskTree());    

    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", mManager.getTaskTree());    

    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
      simulateInteraction(element1, interaction2);
      simulateInteraction(element1, interaction3);
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", mManager.getTaskTree());    
    
    // now test with preceding and trailing other interactions
    Interaction interaction4 = new DummyInteraction("ble", 1);
    Interaction interaction5 = new DummyInteraction("blo", 1);
    Interaction interaction6 = new DummyInteraction("blu", 1);
    simulateInteraction(element1, interaction4);
    simulateInteraction(element1, interaction5);
    simulateInteraction(element1, interaction6);
    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
      simulateInteraction(element1, interaction2);
      simulateInteraction(element1, interaction3);
    }
    simulateInteraction(element1, interaction6);
    simulateInteraction(element1, interaction5);
    simulateInteraction(element1, interaction4);
    
    new TaskTreeChecker().assertTaskTree
    ("Sequence sequence1 {" +
     "  Iteration iteration1 {" +
     "    Sequence sequence2 {" +
     "      Interaction bla {}" +
     "      Interaction bli {}" +
     "      Interaction blup {}" +
     "    }" +
     "  }" +
     "  Interaction ble {}" +
     "  Interaction blo {}" +
     "  Interaction blu {}" +
     "  Iteration iteration2 {" +
     "    Sequence sequence3 {" +
     "      Interaction bla {}" +
     "      Interaction bli {}" +
     "      Interaction blup {}" +
     "    }" +
     "  }" +
     "  Interaction blu {}" +
     "  Interaction blo {}" +
     "  Interaction ble {}" +
     "}", mManager.getTaskTree());    
  
    // now test with iterations of iterations
    for (int i = 0; i < 10; i++)
    {
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction3);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction3);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction3);
      }
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction ble {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "  Iteration iteration2 {" +
       "    Sequence sequence3 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction blu {}" +
       "  Interaction blo {}" +
       "  Interaction ble {}" +
       "  Iteration iteration3 {" +
       "    Sequence sequence4 {" +
       "      Iteration iteration4 {" +
       "        Sequence sequence4 {" +
       "          Interaction bla {}" +
       "          Interaction bli {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "      Iteration iteration5 {" +
       "        Sequence sequence5 {" +
       "          Interaction bli {}" +
       "          Interaction bla {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "      Iteration iteration6 {" +
       "        Sequence sequence6 {" +
       "          Interaction bla {}" +
       "          Interaction bli {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "    }" +
       "  }" +
       "}", mManager.getTaskTree());    
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testGUIElementHierarchyChanges() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement parent1 = new DummyGUIElement("parent1");
    GUIElement parent2 = new DummyGUIElement("parent2");
    GUIElement parent3 = new DummyGUIElement("parent3");
    
    element1.setParent(parent1);
    element2.setParent(parent2);
    element3.setParent(parent3);
    
    parent1.setParent(parent2);
    parent2.setParent(parent3);
    
    Interaction interaction1 = new DummyInteraction("bla", 1);
    simulateInteraction(element1, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element3, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element3, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element1, interaction1);
   
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Iteration iteration0 {" +
       "    Sequence sequence3 {" +
       "      Sequence sequence4 {" +
       "        Interaction bla {}" +
       "      }" +
       "      Sequence sequence5 {" +
       "        Interaction bla {}" +
       "      }" +
       "    }" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", mManager.getTaskTree());    

  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   * @param interactionsDoNotOverwriteElement
   */
  //-----------------------------------------------------------------------------------------------
  private void simulateInteraction(GUIElement GUIElement, Interaction interaction)
  {
    mManager.handleNewInteractionEvent(new InteractionEvent(GUIElement, interaction));
  }

}
