package de.ugoe.cs.util;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>StringToolsTest</code> contains tests for the class
 * <code>{@link StringTools}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class StringToolsTest {

	@Test
	public void testXmlEntityReplacement_1() throws Exception {
		String str = "abc";

		String result = StringTools.xmlEntityReplacement(str);

		// add additional test code here
		assertEquals("abc", result);
	}

	@Test
	public void testXmlEntityReplacement_2() throws Exception {
		String str = "a&bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&amp;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_3() throws Exception {
		String str = "a\"bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&quot;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_4() throws Exception {
		String str = "a'bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&apos;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_5() throws Exception {
		String str = "a<bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&lt;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_6() throws Exception {
		String str = "a>bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&gt;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_7() throws Exception {
		String str = "a&amp;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&amp;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_8() throws Exception {
		String str = "a&quot;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&quot;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_9() throws Exception {
		String str = "a&apos;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&apos;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_10() throws Exception {
		String str = "a&lt;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&lt;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_11() throws Exception {
		String str = "a&gt;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&gt;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_12() throws Exception {
		String str = "a&foo;bc";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&amp;foo;bc", result);
	}

	@Test
	public void testXmlEntityReplacement_13() throws Exception {
		String str = "a&b&c";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("a&amp;b&amp;c", result);
	}
	
	@Test
	public void testXmlEntityReplacement_14() throws Exception {
		String str = "";
		String result = StringTools.xmlEntityReplacement(str);
		assertEquals("", result);
	}
	
	@Test
	public void testXmlEntityReplacement_15() throws Exception {
		String str = null;
		String result = StringTools.xmlEntityReplacement(str);
		assertNull(result);
	}

	@Before
	public void setUp() throws Exception {
		// add additional set up code here
	}

	@After
	public void tearDown() throws Exception {
		// Add additional tear down code here
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(StringToolsTest.class);
	}
}