//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: NodeIdentityRule.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 19.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.nodeequality;

import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class SelectionComparisonRule implements NodeComparisonRule
{

  /** */
  private NodeEqualityRuleManager mRuleManager;

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  SelectionComparisonRule(NodeEqualityRuleManager ruleManager)
  {
    super();
    mRuleManager = ruleManager;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.nodeequality.NodeEqualityRule#apply(TaskTreeNode, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public NodeEquality compare(TaskTreeNode node1, TaskTreeNode node2)
  {
    if ((!(node1 instanceof Sequence)) || (!(node2 instanceof Sequence)))
    {
      return null;
    }
    
    // if both sequences do not have children, they are equal although this doesn't make sense
    if ((node1.getChildren().size() == 0) && (node2.getChildren().size() == 0))
    {
      return new NodesEqual();
    }
    
    // Selections are semantically equal, if they have children, which are all semantically equal.
    // they are structurally equals, if they have the same number and order of structurally equal
    // children
    boolean structurallyEqual =
      node1.getChildren().size() == node2.getChildren().size();
    
    for (int i = 0; i < node1.getChildren().size(); i++)
    {
      TaskTreeNode child1 = node1.getChildren().get(i);
      
      for (int j = 0; j < node2.getChildren().size(); j++)
      {
        TaskTreeNode child2 = node2.getChildren().get(j);
      
        NodeEquality nodeEquality = mRuleManager.applyRules(child1, child2);
        
        if (!nodeEquality.getSemanticalEquality())
        {
          return null;
        }
        else if (structurallyEqual && (i == j))
        {
          // if we compare two children at the same position and if they are structurally equal
          // then it can be further expected, that the selections are structurally equal
          structurallyEqual &= nodeEquality.getStructuralEquality();
        }
      }
    }
    
    if (structurallyEqual)
    {
      return new NodesEqual();
    }
    else
    {
      return new NodesSemanticallyEqual();
    }
  }

}
