/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponent3DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Renderer;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture2DRetained;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Texture3DRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureCubeMap;
import javax.media.j3d.TextureCubeMapRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;

abstract class TextureRetained
extends NodeComponentRetained {
    static final int ENABLE_CHANGED = 1;
    static final int COLOR_CHANGED = 2;
    static final int IMAGE_CHANGED = 4;
    static final int STATE_CHANGED = 8;
    static final int UPDATE_IMAGE = 16;
    static final int IMAGES_CHANGED = 32;
    static final int BASE_LEVEL_CHANGED = 64;
    static final int MAX_LEVEL_CHANGED = 128;
    static final int MIN_LOD_CHANGED = 256;
    static final int MAX_LOD_CHANGED = 512;
    static final int LOD_OFFSET_CHANGED = 1024;
    static final int MIN_FILTER = 0;
    static final int MAG_FILTER = 1;
    int boundaryWidth = 0;
    int boundaryModeS = 3;
    int boundaryModeT = 3;
    int minFilter = 2;
    int magFilter = 2;
    int isDirty = 65535;
    Color4f boundaryColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int objectId = -1;
    int mipmapMode = 1;
    int format = 5;
    int width = 1;
    int height = 1;
    ImageComponentRetained[][] images;
    boolean imagesLoaded = false;
    int mipmapLevels;
    int maxLevels = 0;
    int maxMipMapLevels = 0;
    int numFaces = 1;
    int baseLevel = 0;
    int maximumLevel = 0;
    float minimumLod = -1000.0f;
    float maximumLod = 1000.0f;
    Point3f lodOffset = null;
    boolean enable = true;
    boolean userSpecifiedEnable = true;
    boolean isAlphaNeedUpdate = false;
    int numSharpenTextureFuncPts = 0;
    float[] sharpenTextureFuncPts = null;
    float[] filter4FuncPts = null;
    int anisotropicFilterMode = 0;
    float anisotropicFilterDegree = 1.0f;
    int resourceCreationMask = 0;
    int resourceUpdatedMask = 0;
    int resourceLodUpdatedMask = 0;
    int resourceInReloadList = 0;
    ArrayList[][] imageUpdateInfo;
    int[] imageUpdatePruneMask;
    int textureBinRefCount = 0;
    private int texTimestamp = 0;
    Object resourceLock = new Object();

    TextureRetained() {
    }

    void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mipmapMode = n6;
        this.format = n;
        this.width = n2;
        this.height = n4;
        this.boundaryWidth = n7;
        this.maxMipMapLevels = n3 > n5 ? n3 + 1 : n5 + 1;
        if (n6 != 1) {
            this.baseLevel = 0;
            this.maximumLevel = this.maxMipMapLevels - 1;
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        this.images = new ImageComponentRetained[this.numFaces][this.maxLevels];
        int n8 = 0;
        while (n8 < this.numFaces) {
            int n9 = 0;
            while (n9 < this.maxLevels) {
                this.images[n8][n9] = null;
                ++n9;
            }
            ++n8;
        }
        this.imagesLoaded = false;
    }

    final int getFormat() {
        return this.format;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int numMipMapLevels() {
        return this.maximumLevel - this.baseLevel + 1;
    }

    final void initBoundaryModeS(int n) {
        this.boundaryModeS = n;
    }

    final int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    final void initBoundaryModeT(int n) {
        this.boundaryModeT = n;
    }

    final int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    final int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    final void initMinFilter(int n) {
        this.minFilter = n;
    }

    final int getMinFilter() {
        return this.minFilter;
    }

    final void initMagFilter(int n) {
        this.magFilter = n;
    }

    final int getMagFilter() {
        return this.magFilter;
    }

    void initImage(int n, ImageComponent imageComponent) {
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (this.source instanceof Texture2D) {
            if (imageComponent instanceof ImageComponent3D) {
                throw new IllegalArgumentException(J3dI18N.getString("Texture8"));
            }
        } else if (imageComponent instanceof ImageComponent2D) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture14"));
        }
        if (this.source.isLive()) {
            if (this.images[0][n] != null) {
                this.images[0][n].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        if (this instanceof Texture2DRetained) {
            ((ImageComponent2DRetained)imageComponent.retained).setTextureRef();
        } else {
            ((ImageComponent3DRetained)imageComponent.retained).setTextureRef();
        }
        this.images[0][n] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void checkImageSize(int n, ImageComponent imageComponent) {
        if (imageComponent != null) {
            int n2 = ((ImageComponentRetained)imageComponent.retained).height;
            int n3 = ((ImageComponentRetained)imageComponent.retained).width;
            int n4 = 1;
            int n5 = 0;
            while (n5 < n) {
                ++n5;
                n4 *= 2;
            }
            int n6 = this.height / n4;
            int n7 = this.width / n4;
            if (n6 < 1) {
                n6 = 1;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            if (n6 != n2 || n7 != n3) {
                throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
            }
        }
    }

    final void checkSizes(ImageComponentRetained[] imageComponentRetainedArray) {
        if (imageComponentRetainedArray != null && imageComponentRetainedArray.length > 1) {
            int n = imageComponentRetainedArray[0].width / 2;
            int n2 = imageComponentRetainedArray[0].height / 2;
            int n3 = 1;
            while (n3 < imageComponentRetainedArray.length) {
                int n4 = imageComponentRetainedArray[n3].width;
                int n5 = imageComponentRetainedArray[n3].height;
                if (n < 1) {
                    n = 1;
                }
                if (n2 < 1) {
                    n2 = 1;
                }
                if (n4 != n && n5 != n2) {
                    throw new IllegalArgumentException(J3dI18N.getString("TextureRetained1"));
                }
                n = n4 / 2;
                n2 = n5 / 2;
                ++n3;
            }
        }
    }

    final void setImage(int n, ImageComponent imageComponent) {
        this.checkImageSize(n, imageComponent);
        this.initImage(n, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n), imageComponent, new Integer(0)};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n >= this.baseLevel && n <= this.maximumLevel) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.bImage[0] == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.imageYup == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        int n = 0;
        while (n < imageComponentArray.length) {
            this.initImage(n, imageComponentArray[n]);
            ++n;
        }
    }

    final void setImages(ImageComponent[] imageComponentArray) {
        ImageComponentRetained[] imageComponentRetainedArray = new ImageComponentRetained[imageComponentArray.length];
        int n = 0;
        while (n < imageComponentArray.length) {
            imageComponentRetainedArray[n] = (ImageComponentRetained)imageComponentArray[n].retained;
            ++n;
        }
        this.checkSizes(imageComponentRetainedArray);
        this.initImages(imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        n = 0;
        while (n < imageComponentArray.length) {
            imageComponentArray2[n] = imageComponentArray[n];
            ++n;
        }
        Object[] objectArray = new Object[]{imageComponentArray2, new Integer(0)};
        this.sendMessage(32, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            n = this.baseLevel;
            while (n <= this.maximumLevel && this.enable) {
                if (imageComponentArray[n] != null) {
                    ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n].retained;
                    if (imageComponentRetained.isByReference()) {
                        if (imageComponentRetained.bImage[0] == null) {
                            this.enable = false;
                        }
                    } else if (imageComponentRetained.imageYup == null) {
                        this.enable = false;
                    }
                }
                ++n;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n) {
        return this.images != null && this.images[0][n] != null ? (ImageComponent)this.images[0][n].source : null;
    }

    final ImageComponent[] getImages() {
        if (this.images == null) {
            return null;
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images[0].length];
        int n = 0;
        while (n < this.images[0].length) {
            imageComponentArray[n] = this.images[0][n] != null ? (ImageComponent)this.images[0][n].source : null;
            ++n;
        }
        return imageComponentArray;
    }

    final void initMipMapMode(int n) {
        if (this.mipmapMode == n) {
            return;
        }
        int n2 = this.maxLevels;
        this.mipmapMode = n;
        if (n != 1) {
            this.maxLevels = this.maxMipMapLevels;
        } else {
            this.baseLevel = 0;
            this.maximumLevel = 0;
            this.maxLevels = 1;
        }
        ImageComponentRetained[][] imageComponentRetainedArray = new ImageComponentRetained[this.numFaces][this.maxLevels];
        if (n2 < this.maxLevels) {
            int n3 = 0;
            while (n3 < this.numFaces) {
                int n4 = 0;
                while (n4 < n2) {
                    imageComponentRetainedArray[n3][n4] = this.images[n3][n4];
                    ++n4;
                }
                int n5 = n2;
                while (n5 < this.maxLevels) {
                    imageComponentRetainedArray[n3][n5] = null;
                    ++n5;
                }
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < this.numFaces) {
                int n7 = 0;
                while (n7 < this.maxLevels) {
                    imageComponentRetainedArray[n6][n7] = this.images[n6][n7];
                    ++n7;
                }
                ++n6;
            }
        }
        this.images = imageComponentRetainedArray;
    }

    final int getMipMapMode() {
        return this.mipmapMode;
    }

    final void initEnable(boolean bl) {
        this.userSpecifiedEnable = bl;
    }

    final void setEnable(boolean bl) {
        this.initEnable(bl);
        if (bl == this.enable) {
            return;
        }
        this.enable = bl;
        int n = 0;
        while (n < this.numFaces && this.enable) {
            int n2 = this.baseLevel;
            while (n2 <= this.maximumLevel && this.enable) {
                if (this.images[n][n2].isByReference()) {
                    if (this.images[n][n2].bImage[0] == null) {
                        this.enable = false;
                    }
                } else if (this.images[n][n2].imageYup == null) {
                    this.enable = false;
                }
                ++n2;
            }
            ++n;
        }
        this.sendMessage(1, this.enable ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.userSpecifiedEnable;
    }

    final void initBaseLevel(int n) {
        if (n < 0 || n > this.maximumLevel) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture36"));
        }
        this.baseLevel = n;
    }

    final void setBaseLevel(int n) {
        if (n == this.baseLevel) {
            return;
        }
        this.initBaseLevel(n);
        this.sendMessage(64, new Integer(n));
    }

    final int getBaseLevel() {
        return this.baseLevel;
    }

    final void initMaximumLevel(int n) {
        if (n < this.baseLevel || n >= this.maxMipMapLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture37"));
        }
        this.maximumLevel = n;
    }

    final void setMaximumLevel(int n) {
        if (n == this.maximumLevel) {
            return;
        }
        this.initMaximumLevel(n);
        this.sendMessage(128, new Integer(n));
    }

    final int getMaximumLevel() {
        return this.maximumLevel;
    }

    final void initMinimumLOD(float f) {
        if (f > this.maximumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.minimumLod = f;
    }

    final void setMinimumLOD(float f) {
        this.initMinimumLOD(f);
        this.sendMessage(256, new Float(f));
    }

    final float getMinimumLOD() {
        return this.minimumLod;
    }

    final void initMaximumLOD(float f) {
        if (f < this.minimumLod) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture42"));
        }
        this.maximumLod = f;
    }

    final void setMaximumLOD(float f) {
        this.initMaximumLOD(f);
        this.sendMessage(512, new Float(f));
    }

    final float getMaximumLOD() {
        return this.maximumLod;
    }

    final void initLodOffset(float f, float f2, float f3) {
        if (this.lodOffset == null) {
            this.lodOffset = new Point3f(f, f2, f3);
        } else {
            this.lodOffset.set(f, f2, f3);
        }
    }

    final void setLodOffset(float f, float f2, float f3) {
        this.initLodOffset(f, f2, f3);
        this.sendMessage(1024, new Point3f(f, f2, f3));
    }

    final void getLodOffset(Tuple3f tuple3f) {
        if (this.lodOffset == null) {
            tuple3f.set(0.0f, 0.0f, 0.0f);
        } else {
            tuple3f.set((Tuple3f)this.lodOffset);
        }
    }

    final void initBoundaryColor(Color4f color4f) {
        this.boundaryColor.set((Tuple4f)color4f);
    }

    final void initBoundaryColor(float f, float f2, float f3, float f4) {
        this.boundaryColor.set(f, f2, f3, f4);
    }

    final void getBoundaryColor(Color4f color4f) {
        color4f.set((Tuple4f)this.boundaryColor);
    }

    final void initAnisotropicFilterMode(int n) {
        this.anisotropicFilterMode = n;
    }

    final int getAnisotropicFilterMode() {
        return this.anisotropicFilterMode;
    }

    final void initAnisotropicFilterDegree(float f) {
        this.anisotropicFilterDegree = f;
    }

    final float getAnisotropicFilterDegree() {
        return this.anisotropicFilterDegree;
    }

    final void initSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[fArray.length * 2];
            }
            int n = 0;
            int n2 = 0;
            while (n < fArray.length) {
                this.sharpenTextureFuncPts[n2++] = fArray[n];
                this.sharpenTextureFuncPts[n2++] = fArray2[n];
                ++n;
            }
        }
    }

    final void initSharpenTextureFunc(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = point2fArray.length;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != point2fArray.length * 2) {
                this.sharpenTextureFuncPts = new float[point2fArray.length * 2];
            }
            int n = 0;
            int n2 = 0;
            while (n < point2fArray.length) {
                this.sharpenTextureFuncPts[n2++] = point2fArray[n].x;
                this.sharpenTextureFuncPts[n2++] = point2fArray[n].y;
                ++n;
            }
        }
    }

    final void initSharpenTextureFunc(float[] fArray) {
        if (fArray == null) {
            this.sharpenTextureFuncPts = null;
            this.numSharpenTextureFuncPts = 0;
        } else {
            this.numSharpenTextureFuncPts = fArray.length / 2;
            if (this.sharpenTextureFuncPts == null || this.sharpenTextureFuncPts.length != fArray.length) {
                this.sharpenTextureFuncPts = new float[fArray.length];
            }
            int n = 0;
            while (n < fArray.length) {
                this.sharpenTextureFuncPts[n] = fArray[n];
                ++n;
            }
        }
    }

    final int getSharpenTextureFuncPointsCount() {
        return this.numSharpenTextureFuncPts;
    }

    final void getSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (this.sharpenTextureFuncPts != null) {
            int n = 0;
            int n2 = 0;
            while (n < this.numSharpenTextureFuncPts) {
                fArray[n] = this.sharpenTextureFuncPts[n2++];
                fArray2[n] = this.sharpenTextureFuncPts[n2++];
                ++n;
            }
        }
    }

    final void getSharpenTextureFunc(Point2f[] point2fArray) {
        if (this.sharpenTextureFuncPts != null) {
            int n = 0;
            int n2 = 0;
            while (n < this.numSharpenTextureFuncPts) {
                point2fArray[n].x = this.sharpenTextureFuncPts[n2++];
                point2fArray[n].y = this.sharpenTextureFuncPts[n2++];
                ++n;
            }
        }
    }

    final void initFilter4Func(float[] fArray) {
        if (fArray == null) {
            this.filter4FuncPts = null;
        } else {
            if (this.filter4FuncPts == null || this.filter4FuncPts.length != fArray.length) {
                this.filter4FuncPts = new float[fArray.length];
            }
            int n = 0;
            while (n < fArray.length) {
                this.filter4FuncPts[n] = fArray[n];
                ++n;
            }
        }
    }

    final int getFilter4FuncPointsCount() {
        if (this.filter4FuncPts == null) {
            return 0;
        }
        return this.filter4FuncPts.length;
    }

    final void getFilter4Func(float[] fArray) {
        if (this.filter4FuncPts != null) {
            int n = 0;
            while (n < this.filter4FuncPts.length) {
                fArray[n] = this.filter4FuncPts[n];
                ++n;
            }
        }
    }

    final float[] getSharpenTextureFunc() {
        return this.sharpenTextureFuncPts;
    }

    final float[] getFilter4Func() {
        return this.filter4FuncPts;
    }

    void setLive(boolean bl, int n) {
        int n2;
        int n3;
        if (this.images != null) {
            n3 = 0;
            while (n3 < this.numFaces) {
                this.checkSizes(this.images[n3]);
                ++n3;
            }
        }
        this.enable = this.userSpecifiedEnable;
        super.doSetLive(bl, n);
        if (this.images != null) {
            n3 = 0;
            while (n3 < this.numFaces) {
                n2 = 0;
                while (n2 < this.maxLevels) {
                    if (this.images[n3][n2] == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("TextureRetained3") + n2);
                    }
                    this.images[n3][n2].setLive(bl, n);
                    ++n2;
                }
                ++n3;
            }
        }
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        j3dMessage.args[2] = null;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        if (this.userSpecifiedEnable) {
            if (this.images != null) {
                n2 = 0;
                while (n2 < this.numFaces && this.enable) {
                    int n4 = this.baseLevel;
                    while (n4 <= this.maximumLevel && this.enable) {
                        if (this.images[n2][n4].isByReference()) {
                            if (this.images[n2][n4].bImage[0] == null) {
                                this.enable = false;
                            }
                        } else if (this.images[n2][n4].imageYup == null) {
                            this.enable = false;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            } else {
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
        super.markAsLive();
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.images != null) {
            int n2 = 0;
            while (n2 < this.numFaces) {
                int n3 = 0;
                while (n3 < this.maxLevels) {
                    this.images[n2][n3].clearLive(n);
                    this.images[n2][n3].removeUser(this.mirror);
                    ++n3;
                }
                ++n2;
            }
        }
    }

    native void bindTexture(long var1, int var3, boolean var4);

    native void updateTextureFilterModes(long var1, int var3, int var4);

    native void updateTextureLodRange(long var1, int var3, int var4, float var5, float var6);

    native void updateTextureLodOffset(long var1, float var3, float var4, float var5);

    native void updateTextureBoundary(long var1, int var3, int var4, float var5, float var6, float var7, float var8);

    native void updateTextureSharpenFunc(long var1, int var3, float[] var4);

    native void updateTextureFilter4Func(long var1, int var3, float[] var4);

    native void updateTextureAnisotropicFilter(long var1, float var3);

    native void updateTextureImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    native void updateTextureSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, byte[] var13);

    int getTextureId() {
        return VirtualUniverse.mc.getTexture2DId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTextureId(int n) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == n) {
                this.objectId = -1;
                VirtualUniverse.mc.freeTexture2DId(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindTexture(Canvas3D canvas3D) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectId == -1) {
                this.objectId = this.getTextureId();
            }
            canvas3D.addTextureResource(this.objectId, this);
        }
        this.bindTexture(canvas3D.ctx, this.objectId, this.enable);
    }

    void updateTextureDimensions(Canvas3D canvas3D) {
        this.updateTextureImage(canvas3D.ctx, this.maxLevels, 0, this.format, 1, this.width, this.height, this.boundaryWidth, null);
    }

    void updateTextureLOD(Canvas3D canvas3D) {
        if ((canvas3D.textureExtendedFeatures & 0x1000) != 0) {
            this.updateTextureLodRange(canvas3D.ctx, this.baseLevel, this.maximumLevel, this.minimumLod, this.maximumLod);
        }
        if (this.lodOffset != null && (canvas3D.textureExtendedFeatures & 0x2000) != 0) {
            this.updateTextureLodOffset(canvas3D.ctx, this.lodOffset.x, this.lodOffset.y, this.lodOffset.z);
        }
    }

    void updateTextureBoundary(Canvas3D canvas3D) {
        this.updateTextureBoundary(canvas3D.ctx, this.boundaryModeS, this.boundaryModeT, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
    }

    void updateTextureFields(Canvas3D canvas3D) {
        int n = this.magFilter;
        int n2 = this.minFilter;
        if (this.magFilter >= 9 && this.magFilter <= 11) {
            if ((canvas3D.textureExtendedFeatures & 0x100) != 0) {
                this.updateTextureSharpenFunc(canvas3D.ctx, this.numSharpenTextureFuncPts, this.sharpenTextureFuncPts);
            } else {
                n = 3;
            }
        } else if (this.magFilter >= 6 && this.magFilter <= 8 && (canvas3D.textureExtendedFeatures & 0x200) == 0) {
            n = 3;
        }
        if (this.minFilter == 12 || this.magFilter == 12) {
            boolean bl = false;
            if ((canvas3D.textureExtendedFeatures & 0x400) != 0) {
                if (this.filter4FuncPts == null) {
                    bl = true;
                } else {
                    this.updateTextureFilter4Func(canvas3D.ctx, this.filter4FuncPts.length, this.filter4FuncPts);
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (this.minFilter == 12) {
                    n2 = 3;
                }
                if (this.magFilter == 12) {
                    n = 3;
                }
            }
        }
        this.updateTextureFilterModes(canvas3D.ctx, n2, n);
        if ((canvas3D.textureExtendedFeatures & 0x800) != 0) {
            if (this.anisotropicFilterMode == 0) {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, 1.0f);
            } else {
                this.updateTextureAnisotropicFilter(canvas3D.ctx, this.anisotropicFilterDegree);
            }
        }
        this.updateTextureBoundary(canvas3D);
    }

    void updateTextureImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.updateTextureImage(canvas3D.ctx, this.maxLevels, n3, n4, n5, n6, n7, n8, byArray);
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray) {
        this.updateTextureSubImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byArray);
    }

    void reloadTextureImage(Canvas3D canvas3D, int n, int n2, ImageComponentRetained imageComponentRetained, int n3) {
        this.updateTextureImage(canvas3D, n, n3, n2, this.format, imageComponentRetained.storedYupFormat, imageComponentRetained.width, imageComponentRetained.height, this.boundaryWidth, imageComponentRetained.imageYup);
        if (imageComponentRetained.imageYupClass == 2) {
            int n4 = 0;
            int n5 = 0;
            int n6 = imageComponentRetained.width;
            int n7 = imageComponentRetained.height;
            int n8 = imageComponentRetained.minTileX * imageComponentRetained.tilew + imageComponentRetained.tileGridXOffset + imageComponentRetained.tilew;
            int n9 = imageComponentRetained.minTileY * imageComponentRetained.tileh + imageComponentRetained.tileGridYOffset + imageComponentRetained.tileh;
            int n10 = n8 - imageComponentRetained.minX;
            int n11 = n9 - imageComponentRetained.minY;
            if (n6 < n10) {
                n10 = n6;
            }
            if (n7 < n11) {
                n11 = n7;
            }
            int n12 = n10;
            int n13 = imageComponentRetained.tilew - n10;
            int n14 = imageComponentRetained.tileh - n11;
            int n15 = imageComponentRetained.minTileY;
            while (n15 < imageComponentRetained.minTileY + imageComponentRetained.numYTiles) {
                n4 = 0;
                n6 = this.width;
                n10 = n12;
                n13 = imageComponentRetained.tilew - n10;
                int n16 = imageComponentRetained.minTileX;
                while (n16 < imageComponentRetained.minTileX + imageComponentRetained.numXTiles) {
                    Raster raster = imageComponentRetained.bImage[0].getTile(n16, n15);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n, n2, n4, n5, this.format, imageComponentRetained.storedYupFormat, n13, n14, imageComponentRetained.tilew, n10, n11, byArray);
                    n4 += n10;
                    n13 = 0;
                    n10 = (n6 -= n10) < imageComponentRetained.tilew ? n6 : imageComponentRetained.tilew;
                    ++n16;
                }
                n5 += n11;
                n14 = 0;
                n11 = (n7 -= n11) < imageComponentRetained.tileh ? n7 : imageComponentRetained.tileh;
                ++n15;
            }
        }
    }

    void reloadTextureSubImage(Canvas3D canvas3D, int n, int n2, ImageComponentUpdateInfo imageComponentUpdateInfo, ImageComponentRetained imageComponentRetained) {
        int n3 = imageComponentUpdateInfo.x;
        int n4 = imageComponentUpdateInfo.y;
        int n5 = imageComponentUpdateInfo.width;
        int n6 = imageComponentUpdateInfo.height;
        if (imageComponentRetained.imageYupClass == 1) {
            byte[] byArray;
            int n7 = n3 - imageComponentRetained.minX;
            int n8 = n4 - imageComponentRetained.minY;
            if (imageComponentRetained.imageYupAllocated) {
                byArray = imageComponentRetained.imageYup;
                n8 = imageComponentRetained.height - n8 - n6;
            } else {
                byArray = ((DataBufferByte)imageComponentRetained.bImage[0].getData().getDataBuffer()).getData();
                if (!imageComponentRetained.yUp) {
                    n8 = imageComponentRetained.height - n8 - n6;
                }
            }
            this.updateTextureSubImage(canvas3D, n, n2, n7, n8, this.format, imageComponentRetained.storedYupFormat, n7, n8, imageComponentRetained.width, n5, n6, byArray);
        } else {
            int n9 = imageComponentRetained.tileGridXOffset;
            int n10 = imageComponentRetained.tileGridYOffset;
            int n11 = n3 + imageComponentRetained.minX;
            int n12 = n4 + imageComponentRetained.minY;
            float f = (float)(n11 - n9) / (float)imageComponentRetained.tilew;
            int n13 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
            f = (float)(n12 - n10) / (float)imageComponentRetained.tileh;
            int n14 = f < 0.0f ? (int)(f - 1.0f) : (int)f;
            int n15 = n13 * imageComponentRetained.tilew + n9;
            int n16 = n14 * imageComponentRetained.tilew + n10;
            int n17 = n15 + imageComponentRetained.tilew - n11;
            int n18 = n16 + imageComponentRetained.tileh - n12;
            if (n17 > n5) {
                n17 = n5;
            }
            if (n18 > n6) {
                n18 = n6;
            }
            int n19 = n17;
            int n20 = n5;
            int n21 = n6;
            int n22 = n11 - n15;
            int n23 = n12 - n16;
            int n24 = (n5 + n22) / imageComponentRetained.tilew;
            int n25 = (n6 + n23) / imageComponentRetained.tileh;
            if ((float)(n5 + n22) % (float)imageComponentRetained.tilew > 0.0f) {
                ++n24;
            }
            if ((float)(n6 + n23) % (float)imageComponentRetained.tileh > 0.0f) {
                ++n25;
            }
            int n26 = n3;
            int n27 = n4;
            int n28 = n14;
            while (n28 < n14 + n25) {
                n20 = n5;
                n17 = n19;
                n22 = n11 - n15;
                int n29 = n13;
                while (n29 < n13 + n24) {
                    Raster raster = imageComponentRetained.bImage[0].getTile(n29, n28);
                    byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
                    this.updateTextureSubImage(canvas3D, n, n2, n26, n27, this.format, imageComponentRetained.storedYupFormat, n22, n23, imageComponentRetained.tilew, n17, n18, byArray);
                    n26 += n17;
                    n22 = 0;
                    n17 = (n20 -= n17) < imageComponentRetained.tilew ? n20 : imageComponentRetained.tilew;
                    ++n29;
                }
                n27 += n18;
                n23 = 0;
                n18 = (n21 -= n18) < imageComponentRetained.tileh ? n21 : imageComponentRetained.tileh;
                ++n28;
            }
        }
    }

    void reloadTexture(Canvas3D canvas3D) {
        int n;
        int n2;
        if ((canvas3D.textureExtendedFeatures & 0x1000) == 0) {
            n2 = 0;
            n = this.maxLevels - 1;
        } else {
            n2 = this.baseLevel;
            n = this.maximumLevel;
        }
        if (n2 != 0) {
            this.updateTextureDimensions(canvas3D);
        }
        int n3 = 0;
        while (n3 < this.numFaces) {
            int n4 = n2;
            while (n4 <= n) {
                if (this.images[n3][n4] != null) {
                    this.reloadTextureImage(canvas3D, n3, n4, this.images[n3][n4], this.maxLevels);
                }
                ++n4;
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTexture(Canvas3D canvas3D, int n) {
        int n2 = 0;
        while (n2 < this.numFaces) {
            int n3 = this.baseLevel;
            while (n3 <= this.maximumLevel) {
                if (this.imageUpdateInfo[n2][n3] != null) {
                    int n4 = 0;
                    while (n4 < this.imageUpdateInfo[n2][n3].size()) {
                        block12: {
                            ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[n2][n3].get(n4);
                            Object object = this.resourceLock;
                            synchronized (object) {
                                if ((imageComponentUpdateInfo.updateMask & n) == 0) {
                                    break block12;
                                }
                                imageComponentUpdateInfo.updateMask &= ~n;
                                if ((imageComponentUpdateInfo.updateMask & this.resourceCreationMask) == 0) {
                                    imageComponentUpdateInfo.updateMask = 0;
                                    if (this.imageUpdatePruneMask == null) {
                                        this.imageUpdatePruneMask = new int[this.numFaces];
                                    }
                                    this.imageUpdatePruneMask[n2] = 1 << n3;
                                }
                            }
                            if (imageComponentUpdateInfo.entireImage) {
                                this.reloadTextureImage(canvas3D, n2, n3, this.images[n2][n3], this.maxLevels);
                            } else {
                                this.reloadTextureSubImage(canvas3D, n2, n3, imageComponentUpdateInfo, this.images[n2][n3]);
                            }
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadTextureSharedContext(Canvas3D canvas3D) {
        if (!this.enable) {
            return;
        }
        this.bindTexture(canvas3D);
        this.updateTextureFields(canvas3D);
        this.updateTextureLOD(canvas3D);
        this.reloadTexture(canvas3D);
        Object object = this.resourceLock;
        synchronized (object) {
            this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
            this.resourceInReloadList &= ~canvas3D.screen.renderer.rendererBit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNative(Canvas3D canvas3D) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.bindTexture(canvas3D);
        if (!this.enable) {
            return;
        }
        if (canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != 0L) {
            if ((this.resourceCreationMask & canvas3D.screen.renderer.rendererBit) == 0) {
                bl = true;
            } else {
                if ((this.resourceUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0 && this.imageUpdateInfo != null) {
                    bl2 = true;
                }
                if ((this.resourceLodUpdatedMask & canvas3D.screen.renderer.rendererBit) == 0) {
                    bl3 = true;
                }
            }
            if (bl || bl2 || bl3) {
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
                this.bindTexture(canvas3D);
            }
        } else if ((this.resourceCreationMask & canvas3D.canvasBit) == 0) {
            bl = true;
        } else {
            if ((this.resourceUpdatedMask & canvas3D.canvasBit) == 0 && this.imageUpdateInfo != null) {
                bl2 = true;
            }
            if ((this.resourceLodUpdatedMask & canvas3D.canvasBit) == 0) {
                bl3 = true;
            }
        }
        if (VirtualUniverse.mc.isD3D()) {
            if (this.texTimestamp != VirtualUniverse.mc.resendTexTimestamp) {
                this.texTimestamp = VirtualUniverse.mc.resendTexTimestamp;
                bl = true;
            }
            if (!bl) {
                this.updateTextureFields(canvas3D);
            }
        }
        if (bl) {
            this.updateTextureFields(canvas3D);
            this.updateTextureLOD(canvas3D);
            this.reloadTexture(canvas3D);
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            } else {
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceCreationMask |= canvas3D.canvasBit;
                    this.resourceUpdatedMask |= canvas3D.canvasBit;
                    this.resourceLodUpdatedMask |= canvas3D.canvasBit;
                }
            }
        } else if (bl3 || bl2) {
            if (bl3) {
                this.updateTextureLOD(canvas3D);
            }
            if (bl2) {
                int n = 0;
                n = canvas3D.useSharedCtx ? canvas3D.screen.renderer.rendererBit : canvas3D.canvasBit;
                this.updateTexture(canvas3D, n);
            }
            if (canvas3D.useSharedCtx) {
                canvas3D.makeCtxCurrent(canvas3D.ctx);
                Object object = this.resourceLock;
                synchronized (object) {
                    this.resourceUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                    this.resourceLodUpdatedMask |= canvas3D.screen.renderer.rendererBit;
                }
            }
            Object object = this.resourceLock;
            synchronized (object) {
                this.resourceUpdatedMask |= canvas3D.canvasBit;
                this.resourceLodUpdatedMask |= canvas3D.canvasBit;
            }
        }
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this instanceof Texture3DRetained) {
                Texture3DRetained texture3DRetained = (Texture3DRetained)this;
                Texture3D texture3D = new Texture3D(texture3DRetained.mipmapMode, texture3DRetained.format, texture3DRetained.width, texture3DRetained.height, texture3DRetained.depth, texture3DRetained.boundaryWidth);
                this.mirror = (Texture3DRetained)texture3D.retained;
            } else if (this instanceof TextureCubeMapRetained) {
                TextureCubeMap textureCubeMap = new TextureCubeMap(this.mipmapMode, this.format, this.width, this.boundaryWidth);
                this.mirror = (TextureCubeMapRetained)textureCubeMap.retained;
            } else {
                Texture2D texture2D = new Texture2D(this.mipmapMode, this.format, this.width, this.height, this.boundaryWidth);
                this.mirror = (Texture2DRetained)texture2D.retained;
            }
            ((TextureRetained)this.mirror).objectId = -1;
        }
        this.initMirrorObject();
    }

    synchronized void initMirrorObject() {
        block17: {
            int n;
            TextureRetained textureRetained;
            block16: {
                this.mirror.source = this.source;
                if (this instanceof Texture3DRetained) {
                    textureRetained = (Texture3DRetained)this;
                    ((Texture3DRetained)this.mirror).boundaryModeR = textureRetained.boundaryModeR;
                    ((Texture3DRetained)this.mirror).depth = textureRetained.depth;
                }
                textureRetained = (TextureRetained)this.mirror;
                textureRetained.boundaryModeS = this.boundaryModeS;
                textureRetained.boundaryModeT = this.boundaryModeT;
                textureRetained.minFilter = this.minFilter;
                textureRetained.magFilter = this.magFilter;
                textureRetained.boundaryColor.set((Tuple4f)this.boundaryColor);
                textureRetained.enable = this.enable;
                textureRetained.userSpecifiedEnable = this.enable;
                textureRetained.imagesLoaded = this.imagesLoaded;
                textureRetained.enable = this.enable;
                textureRetained.numFaces = this.numFaces;
                textureRetained.resourceCreationMask = 0;
                textureRetained.resourceUpdatedMask = 0;
                textureRetained.resourceLodUpdatedMask = 0;
                textureRetained.resourceInReloadList = 0;
                textureRetained.baseLevel = this.baseLevel;
                textureRetained.maximumLevel = this.maximumLevel;
                textureRetained.minimumLod = this.minimumLod;
                textureRetained.maximumLod = this.maximumLod;
                textureRetained.lodOffset = this.lodOffset;
                textureRetained.numSharpenTextureFuncPts = this.numSharpenTextureFuncPts;
                if (this.sharpenTextureFuncPts == null) {
                    textureRetained.sharpenTextureFuncPts = null;
                } else {
                    if (textureRetained.sharpenTextureFuncPts == null || textureRetained.sharpenTextureFuncPts.length != this.sharpenTextureFuncPts.length) {
                        textureRetained.sharpenTextureFuncPts = new float[this.sharpenTextureFuncPts.length];
                    }
                    n = 0;
                    while (n < this.sharpenTextureFuncPts.length) {
                        textureRetained.sharpenTextureFuncPts[n] = this.sharpenTextureFuncPts[n];
                        ++n;
                    }
                }
                if (this.filter4FuncPts == null) {
                    textureRetained.filter4FuncPts = null;
                } else {
                    if (textureRetained.filter4FuncPts == null || textureRetained.filter4FuncPts.length != this.filter4FuncPts.length) {
                        textureRetained.filter4FuncPts = new float[this.filter4FuncPts.length];
                    }
                    n = 0;
                    while (n < this.filter4FuncPts.length) {
                        textureRetained.filter4FuncPts[n] = this.filter4FuncPts[n];
                        ++n;
                    }
                }
                textureRetained.anisotropicFilterMode = this.anisotropicFilterMode;
                textureRetained.anisotropicFilterDegree = this.anisotropicFilterDegree;
                if (this.mipmapMode != 1 || this.minFilter != 1 && this.minFilter != 4 && this.minFilter != 5) break block16;
                textureRetained.maxLevels = this.maxMipMapLevels;
                if (textureRetained.images == null || textureRetained.images.length < this.numFaces || textureRetained.images[0].length < textureRetained.maxLevels) {
                    textureRetained.images = new ImageComponentRetained[this.numFaces][textureRetained.maxLevels];
                }
                n = 0;
                while (n < this.numFaces) {
                    textureRetained.images[n][0] = this.images[n][0];
                    if (this.images[n][0] != null) {
                        this.images[n][0].addUser(textureRetained);
                    }
                    int n2 = 1;
                    while (n2 < textureRetained.maxLevels) {
                        textureRetained.images[n][n2] = this.createNextLevelImage(textureRetained.images[n][n2 - 1]);
                        ++n2;
                    }
                    ++n;
                }
                break block17;
            }
            textureRetained.maxLevels = this.maxLevels;
            if (this.images == null) break block17;
            n = 0;
            while (n < this.numFaces) {
                int n3 = 0;
                while (n3 < this.maxLevels) {
                    textureRetained.images[n][n3] = this.images[n][n3];
                    if (this.images[n][n3] != null) {
                        this.images[n][n3].addUser(textureRetained);
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    void pruneImageUpdateInfo() {
        int n = 0;
        while (n < this.numFaces) {
            int n2 = this.baseLevel;
            while (n2 <= this.maximumLevel) {
                if ((this.imageUpdatePruneMask[n] & 1 << n2) != 0) {
                    if (this.imageUpdateInfo[n][n2] != null) {
                        int n3 = 0;
                        while (n3 < this.imageUpdateInfo[n][n2].size()) {
                            ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)this.imageUpdateInfo[n][n2].get(n3);
                            if (imageComponentUpdateInfo.updateMask == 0) {
                                VirtualUniverse.mc.addFreeImageUpdateInfo(imageComponentUpdateInfo);
                                this.imageUpdateInfo[n][n2].remove(n3);
                            }
                            ++n3;
                        }
                    }
                    int n4 = n;
                    this.imageUpdatePruneMask[n4] = this.imageUpdatePruneMask[n4] & ~(1 << n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    void addImageUpdateInfo(int n, int n2, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.imageUpdateInfo == null) {
            this.imageUpdateInfo = new ArrayList[this.numFaces][this.maxLevels];
        }
        if (this.imageUpdateInfo[n2][n] == null) {
            this.imageUpdateInfo[n2][n] = new ArrayList();
        }
        ImageComponentUpdateInfo imageComponentUpdateInfo2 = VirtualUniverse.mc.getFreeImageUpdateInfo();
        imageComponentUpdateInfo2.entireImage = imageComponentUpdateInfo == null ? true : imageComponentUpdateInfo.width >= this.width / 2 && imageComponentUpdateInfo.height >= this.height / 2;
        if (imageComponentUpdateInfo2.entireImage) {
            VirtualUniverse.mc.addFreeImageUpdateInfo(this.imageUpdateInfo[n2][n]);
            this.imageUpdateInfo[n2][n].clear();
            if (this.imageUpdatePruneMask != null) {
                int n3 = n2;
                this.imageUpdatePruneMask[n3] = this.imageUpdatePruneMask[n3] & ~(1 << n);
            }
        } else {
            imageComponentUpdateInfo2.x = imageComponentUpdateInfo.x;
            imageComponentUpdateInfo2.y = imageComponentUpdateInfo.y;
            imageComponentUpdateInfo2.z = imageComponentUpdateInfo.z;
            imageComponentUpdateInfo2.width = imageComponentUpdateInfo.width;
            imageComponentUpdateInfo2.height = imageComponentUpdateInfo.height;
        }
        imageComponentUpdateInfo2.updateMask = this.resourceCreationMask;
        this.imageUpdateInfo[n2][n].add(imageComponentUpdateInfo2);
        if (this.imageUpdatePruneMask != null) {
            this.pruneImageUpdateInfo();
        }
    }

    void validate() {
        this.enable = true;
        int n = 0;
        while (n < this.numFaces && this.enable) {
            int n2 = this.baseLevel;
            while (n2 <= this.maximumLevel && this.enable) {
                if (this.images[n][n2] == null) {
                    this.enable = false;
                }
                ++n2;
            }
            ++n;
        }
    }

    synchronized void updateMirrorObject(int n, Object object) {
        TextureRetained textureRetained = (TextureRetained)this.mirror;
        if ((n & 1) != 0) {
            textureRetained.enable = (Boolean)object;
        } else if ((n & 4) != 0) {
            Object[] objectArray = (Object[])object;
            int n2 = (Integer)objectArray[0];
            ImageComponent imageComponent = (ImageComponent)objectArray[1];
            int n3 = (Integer)objectArray[2];
            if (textureRetained.images[n3][n2] != null) {
                textureRetained.images[n3][n2].removeUser(this.mirror);
            }
            if (imageComponent == null) {
                textureRetained.images[n3][n2] = null;
            } else {
                textureRetained.images[n3][n2] = (ImageComponentRetained)imageComponent.retained;
                textureRetained.images[n3][n2].addUser(this.mirror);
            }
            textureRetained.resourceUpdatedMask = 0;
            textureRetained.addImageUpdateInfo(n2, n3, null);
        } else if ((n & 0x20) != 0) {
            Object[] objectArray = (Object[])object;
            ImageComponent[] imageComponentArray = (ImageComponent[])objectArray[0];
            int n4 = (Integer)objectArray[1];
            int n5 = 0;
            while (n5 < imageComponentArray.length) {
                if (textureRetained.images[n4][n5] != null) {
                    textureRetained.images[n4][n5].removeUser(this.mirror);
                }
                if (imageComponentArray[n5] == null) {
                    textureRetained.images[n4][n5] = null;
                } else {
                    textureRetained.images[n4][n5] = (ImageComponentRetained)imageComponentArray[n5].retained;
                    textureRetained.images[n4][n5].addUser(this.mirror);
                }
                ++n5;
            }
            textureRetained.updateResourceCreationMask();
        } else if ((n & 0x40) != 0) {
            int n6 = (Integer)object;
            if (n6 < textureRetained.baseLevel) {
                int n7 = 0;
                while (n7 < this.numFaces) {
                    int n8 = n6;
                    while (n8 < textureRetained.baseLevel) {
                        if (textureRetained.images[n7][n8] == null) {
                            textureRetained.enable = false;
                        } else {
                            textureRetained.addImageUpdateInfo(n8, n7, null);
                        }
                        ++n8;
                    }
                    ++n7;
                }
                textureRetained.baseLevel = n6;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.baseLevel = n6;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x80) != 0) {
            int n9 = (Integer)object;
            if (n9 > textureRetained.maximumLevel) {
                int n10 = 0;
                while (n10 < this.numFaces) {
                    int n11 = textureRetained.maximumLevel;
                    while (n11 < n9) {
                        if (textureRetained.images[n10][n11] == null) {
                            textureRetained.enable = false;
                        } else {
                            textureRetained.addImageUpdateInfo(n11, n10, null);
                        }
                        ++n11;
                    }
                    ++n10;
                }
                textureRetained.maximumLevel = n9;
                textureRetained.resourceUpdatedMask = 0;
            } else {
                textureRetained.maximumLevel = n9;
                if (this.userSpecifiedEnable && !textureRetained.enable) {
                    textureRetained.validate();
                }
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x100) != 0) {
            textureRetained.minimumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x200) != 0) {
            textureRetained.maximumLod = ((Float)object).floatValue();
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x400) != 0) {
            if (textureRetained.lodOffset == null) {
                textureRetained.lodOffset = new Point3f((Point3f)object);
            } else {
                textureRetained.lodOffset.set((Tuple3f)((Point3f)object));
            }
            textureRetained.resourceLodUpdatedMask = 0;
        } else if ((n & 0x10) != 0) {
            textureRetained.updateResourceCreationMask();
        }
    }

    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, ImageComponentUpdateInfo imageComponentUpdateInfo) {
        if (this.resourceCreationMask == 0) {
            if (this.imageUpdateInfo != null) {
                int n = 0;
                while (n < this.numFaces) {
                    int n2 = 0;
                    while (n2 < this.maxLevels) {
                        if (this.imageUpdateInfo[n][n2] != null) {
                            VirtualUniverse.mc.addFreeImageUpdateInfo(this.imageUpdateInfo[n][n2]);
                            this.imageUpdateInfo[n][n2].clear();
                        }
                        ++n2;
                    }
                    if (this.imageUpdatePruneMask != null) {
                        this.imageUpdatePruneMask[n] = 0;
                    }
                    ++n;
                }
            }
            return;
        }
        int n = 0;
        while (n < this.numFaces) {
            boolean bl = false;
            int n3 = this.baseLevel;
            while (n3 <= this.maximumLevel && !bl) {
                if (this.images[n][n3] == imageComponentRetained) {
                    this.resourceUpdatedMask = 0;
                    this.addImageUpdateInfo(n3, n, imageComponentUpdateInfo);
                    bl = true;
                }
                ++n3;
            }
            ++n;
        }
    }

    void updateResourceCreationMask() {
        this.resourceCreationMask = 0;
    }

    final ImageComponentRetained createNextLevelImage(ImageComponentRetained imageComponentRetained) {
        int n;
        int n2;
        int n3;
        int n4;
        ImageComponentRetained imageComponentRetained2 = null;
        if (imageComponentRetained.width > 1) {
            n4 = imageComponentRetained.width >> 1;
            n3 = 2;
        } else {
            n4 = 1;
            n3 = 1;
        }
        if (imageComponentRetained.height > 1) {
            n2 = imageComponentRetained.height >> 1;
            n = 2;
        } else {
            n2 = 1;
            n = 1;
        }
        int n5 = imageComponentRetained.bytesPerYupPixelStored;
        if (imageComponentRetained instanceof ImageComponent2DRetained) {
            imageComponentRetained2 = new ImageComponent2DRetained();
            imageComponentRetained2.processParams(imageComponentRetained.format, n4, n2, 1);
            imageComponentRetained2.imageYup = new byte[n4 * n2 * n5];
            imageComponentRetained2.storedYupFormat = imageComponentRetained2.internalFormat;
            imageComponentRetained2.bytesPerYupPixelStored = n5;
            this.scaleImage(n4, n2, n3, n, imageComponentRetained.width, 0, 0, n5, imageComponentRetained2.imageYup, imageComponentRetained.imageYup);
        } else {
            int n6 = ((ImageComponent3DRetained)imageComponentRetained).depth;
            imageComponentRetained2 = new ImageComponent3DRetained();
            imageComponentRetained2.processParams(imageComponentRetained.format, n4, n2, n6);
            imageComponentRetained2.imageYup = new byte[n4 * n2 * n5];
            imageComponentRetained2.storedYupFormat = imageComponentRetained2.internalFormat;
            imageComponentRetained2.bytesPerYupPixelStored = n5;
            int n7 = 0;
            while (n7 < n6) {
                this.scaleImage(n4, n2, n3, n, imageComponentRetained.width, n7 * n4 * n2 * n5, n7 * imageComponentRetained.width * imageComponentRetained.height * n5, n5, imageComponentRetained2.imageYup, imageComponentRetained.imageYup);
                ++n7;
            }
        }
        return imageComponentRetained2;
    }

    final void scaleImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, byte[] byArray2) {
        int n9 = 0;
        int n10 = 0;
        int n11 = n8 * n5;
        int n12 = n8 << 1;
        if (n4 == 1) {
            int n13 = 0;
            while (n13 < n) {
                int n14 = 0;
                while (n14 < n8) {
                    byArray[n6 + n9 + n14] = (byte)((byArray2[n7 + n10 + n14] & 0xFF) + (byArray2[n7 + n10 + n14 + n8] & 0xFF) + 1 >> 1);
                    ++n14;
                }
                n9 += n8;
                n10 += n12;
                ++n13;
            }
        } else if (n3 == 1) {
            int n15 = 0;
            while (n15 < n2) {
                int n16 = 0;
                while (n16 < n8) {
                    byArray[n6 + n9 + n16] = (byte)((byArray2[n7 + n10 + n16] & 0xFF) + (byArray2[n7 + n10 + n16 + n11] & 0xFF) + 1 >> 1);
                    ++n16;
                }
                n9 += n8;
                n10 += n11;
                ++n15;
            }
        } else {
            int n17 = 0;
            while (n17 < n2) {
                int n18 = 0;
                while (n18 < n) {
                    int n19 = 0;
                    while (n19 < n8) {
                        byArray[n6 + n9 + n19] = (byte)((byArray2[n7 + n10 + n19] & 0xFF) + (byArray2[n7 + n10 + n19 + n8] & 0xFF) + (byArray2[n7 + n10 + n19 + n11] & 0xFF) + (byArray2[n7 + n10 + n19 + n11 + n8] & 0xFF) + 2 >> 2);
                        ++n19;
                    }
                    n9 += n8;
                    n10 += n12;
                    ++n18;
                }
                n10 += n11;
                ++n17;
            }
        }
    }

    void incTextureBinRefCount(TextureBin textureBin) {
        ++this.textureBinRefCount;
        int n = 0;
        while (n < this.numFaces) {
            int n2 = 0;
            while (n2 < this.maxLevels) {
                ImageComponentRetained imageComponentRetained = this.images[n][n2];
                if (imageComponentRetained != null && (imageComponentRetained.isByReference() || imageComponentRetained.source != null && imageComponentRetained.source.getCapability(3))) {
                    textureBin.renderBin.addNodeComponent(imageComponentRetained);
                }
                ++n2;
            }
            ++n;
        }
    }

    void decTextureBinRefCount(TextureBin textureBin) {
        --this.textureBinRefCount;
        int n = 0;
        while (n < this.numFaces) {
            int n2 = 0;
            while (n2 < this.maxLevels) {
                ImageComponentRetained imageComponentRetained = this.images[n][n2];
                if (imageComponentRetained != null && (imageComponentRetained.isByReference() || imageComponentRetained.source != null && imageComponentRetained.source.getCapability(3))) {
                    textureBin.renderBin.removeNodeComponent(imageComponentRetained);
                }
                ++n2;
            }
            ++n;
        }
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 15;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 15;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(n2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        if (this.objectId > 0) {
            Object object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                boolean bl = false;
                Enumeration enumeration = Screen3D.deviceRendererMap.elements();
                while (enumeration.hasMoreElements()) {
                    Renderer renderer = (Renderer)enumeration.nextElement();
                    J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                    j3dMessage.threads = 16;
                    j3dMessage.type = 44;
                    j3dMessage.universe = null;
                    j3dMessage.view = null;
                    j3dMessage.args[0] = null;
                    j3dMessage.args[1] = new Integer(this.objectId);
                    j3dMessage.args[2] = "2D";
                    renderer.rendererStructure.addMessage(j3dMessage);
                }
                this.objectId = -1;
            }
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    void handleFrequencyChange(int n) {
        switch (n) {
            case 1: 
            case 7: 
            case 11: {
                this.setFrequencyChangeMask(n, n);
            }
        }
    }
}

